/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class Palindrome
extends RegularPumpingLemma {
    @Override
    public String getTitle() {
        return "w w^R : w element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>ww<sup>R</sup></i> : <i>w</i> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>bba<sup><i>m</i></sup>\".  The <i>y</i> value thus would be a multiple of \"a\" in 'w' and not in 'w<sup>R</sup>'.  If <i>i</i> = 0, then the total string becomes at most \"a<sup><i>m</i>-1</sup>bba<sup><i>m</i></sup>\", which is not in the language.  Thus, the language is not regular.";
    }

    @Override
    protected void chooseW() {
        this.w = Palindrome.pumpString("a", this.m) + "bb" + Palindrome.pumpString("a", this.m);
    }

    @Override
    public void chooseDecomposition() {
        this.setDecomposition(new int[]{Math.min(this.w.length() / 2 - 1, this.m - 2), 2});
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 10};
    }

    @Override
    public boolean isInLang(String string) {
        int n = string.length();
        if (n == 0) {
            return true;
        }
        if (n % 2 == 1) {
            return false;
        }
        int n2 = n / 2;
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(string, cArray)) {
            return false;
        }
        for (int i = 0; i <= n2; ++i) {
            if (string.charAt(i) == string.charAt(n - i - 1)) continue;
            return false;
        }
        return true;
    }
}

