/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class AnBn
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "a^n b^n : n >= 0";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>n</sup></i> : <i>n</i> " + GREATER_OR_EQ + " 0";
    }

    @Override
    protected void chooseW() {
        this.w = AnBn.pumpString("a", this.m) + AnBn.pumpString("b", this.m);
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a context-free language, a valid decomposition exists.  If <i>m</i> " + GREATER_OR_EQ + " 2, one could choose <i>v</i> to be \"a\" and <i>y</i> to be \"b\", which will work for all values of " + "<i>i</i>.";
    }

    @Override
    public void chooseI() {
        this.i = 2;
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{0, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBn.this.m - 2, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{1, AnBn.this.m - 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBn.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBn.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() == 0 && string2.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBn.this.m, 0, 1, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() > 0 && string2.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBn.this.m, 1, 0, 0};
            }
        });
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{4, 11};
    }

    @Override
    public void chooseDecomposition() {
        this.setDecomposition(new int[]{this.w.length() / 2 - 1, 1, 0, 1});
    }

    @Override
    public boolean isInLang(String string) {
        int n;
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.isMixture(string, cArray)) {
            return false;
        }
        int n2 = LemmaMath.countInstances(string, 'a');
        return n2 == (n = LemmaMath.countInstances(string, 'b'));
    }
}

