/*
 * Decompiled with CFR 0.152.
 */
package pumping;

import gui.environment.Universe;
import java.io.Serializable;
import pumping.Case;
import pumping.LemmaMath;
import pumping.PumpingLemma;

public abstract class ContextFreePumpingLemma
extends PumpingLemma
implements Serializable,
Cloneable {
    protected String u;
    protected String v;
    protected String x;
    protected String y;
    protected String z;

    public String getU() {
        return this.u;
    }

    public String getV() {
        return this.v;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    @Override
    public String getDecompositionAsString() {
        int n;
        String[] stringArray = new String[5];
        int n2 = 0;
        for (n = 0; n <= 3; ++n) {
            stringArray[n] = this.w.substring(n2, n2 + this.myDecomposition[n]);
            n2 += this.myDecomposition[n];
        }
        stringArray[4] = this.w.substring(n2);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() != 0) continue;
            stringArray[n] = Universe.curProfile.getEmptyString();
        }
        return "U = " + stringArray[0] + ";   V = " + stringArray[1] + ";   X = " + stringArray[2] + ";   Y = " + stringArray[3] + ";   Z = " + stringArray[4];
    }

    @Override
    public void reset() {
        this.m = -1;
        this.i = -1;
        this.w = "";
        this.u = "";
        this.v = "";
        this.x = "";
        this.y = "";
        this.z = "";
    }

    @Override
    public boolean setDecomposition(int[] nArray) {
        this.myDecomposition = nArray;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        if (n2 + n3 + n4 > this.m || n2 + n4 < 1) {
            return false;
        }
        this.u = this.w.substring(0, n);
        this.v = this.w.substring(n, n + n2);
        this.x = this.w.substring(n + n2, n + n2 + n3);
        this.y = this.w.substring(n + n2 + n3, n + n2 + n3 + n4);
        this.z = this.w.substring(n + n2 + n3 + n4);
        return true;
    }

    @Override
    public boolean setDecomposition(int[] nArray, int n) {
        this.i = n;
        return this.setDecomposition(nArray);
    }

    @Override
    public String createPumpedString() {
        return this.u + ContextFreePumpingLemma.pumpString(this.v, this.getI()) + this.x + ContextFreePumpingLemma.pumpString(this.y, this.getI()) + this.z;
    }

    @Override
    public int addCase(int[] nArray, int n) {
        int n2;
        if (!this.setDecomposition(nArray)) {
            return -1;
        }
        for (n2 = 0; n2 < this.myDoneCases.size(); ++n2) {
            if (!((Case)this.myDoneCases.get(n2)).isCase(this.v, this.y)) continue;
            return n2;
        }
        for (n2 = 0; n2 < this.myAllCases.size(); ++n2) {
            Case case_ = (Case)this.myAllCases.get(n2);
            if (!case_.isCase(this.v, this.y)) continue;
            case_.setI(n);
            case_.setUserInput(nArray);
            this.myDoneCases.add(case_);
            return this.myAllCases.size();
        }
        System.err.println("BUG FOUND: ContextFreePumpingLemma.addCase(int[], int)");
        return -1;
    }

    @Override
    public boolean replaceCase(int[] nArray, int n, int n2) {
        Case case_ = (Case)this.myDoneCases.get(n2);
        if (case_.isCase(this.v, this.y)) {
            case_.setI(n);
            case_.setUserInput(nArray);
            return true;
        }
        return false;
    }

    private void chooseDecompositionWithoutCases() {
        int[] nArray = new int[4];
        int n = 0;
        int n2 = 0;
        nArray[0] = LemmaMath.fetchRandInt(0, this.w.length() - 1);
        n2 = Math.min(this.w.length() - (n += nArray[0]), this.m);
        nArray[1] = LemmaMath.fetchRandInt(0, n2);
        if (nArray[1] == this.w.length() - n) {
            nArray[2] = 0;
            nArray[3] = 0;
        } else {
            n2 = Math.min(this.w.length() - (n += nArray[1]) - 1, this.m - 1);
            nArray[2] = LemmaMath.fetchRandInt(0, n2);
            n2 = Math.min(this.w.length() - (n += nArray[2]), this.m - nArray[2]);
            nArray[3] = nArray[1] > 0 ? LemmaMath.fetchRandInt(0, n2) : LemmaMath.fetchRandInt(1, n2);
        }
        this.setDecomposition(nArray);
    }

    @Override
    public void chooseDecomposition() {
        this.chooseDecompositionWithoutCases();
    }
}

