/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Automaton;
import automata.Note;
import automata.State;
import automata.Transition;
import automata.event.AutomataStateEvent;
import automata.event.AutomataStateListener;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.mealy.MooreMachine;
import gui.viewer.CurvedArrow;
import gui.viewer.InvisibleCurvedArrow;
import gui.viewer.MooreStateDrawer;
import gui.viewer.StateDrawer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class AutomatonDrawer {
    ArrayList<State> hs = new ArrayList();
    HashSet<Point> lhs = new HashSet();
    int specHash = Integer.MIN_VALUE;
    private Rectangle mySelectionBounds = new Rectangle(0, 0, -1, -1);
    private Automaton automaton;
    private boolean drawLabels = true;
    protected static final double ANGLE = 0.12566370614359174;
    private boolean valid = false;
    private boolean validBounds = false;
    private Rectangle cachedBounds = null;
    public HashMap<Transition, Double> selfTransitionMap = new HashMap();
    public HashMap<Transition, Float> curveTransitionMap = new HashMap();
    public HashMap arrowToTransitionMap = new HashMap();
    public HashMap transitionToArrowMap = new HashMap();
    public StateDrawer statedrawer = new StateDrawer();
    private AffineTransform curTransform = new AffineTransform();

    public AutomatonDrawer(Automaton automaton) {
        this.automaton = automaton;
        DrawerListener drawerListener = new DrawerListener();
        this.getAutomaton().addStateListener(drawerListener);
        this.getAutomaton().addTransitionListener(drawerListener);
        if (automaton instanceof MooreMachine) {
            this.statedrawer = new MooreStateDrawer();
        }
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public void drawAutomaton(Graphics graphics) {
        if (!this.valid) {
            this.refreshArrowMap();
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(graphics2D.getFont().deriveFont(12.0f));
        graphics2D.setColor(Color.black);
        this.drawTransitions(graphics2D);
        State[] stateArray = this.automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            this.drawState(graphics2D, stateArray[i]);
        }
        this.drawSelectionBox(graphics2D);
        graphics2D.dispose();
    }

    public Rectangle getBounds(State state) {
        int n = this.statedrawer.getRadius();
        Point point = state.getPoint();
        int n2 = state.getLabels().length * 15;
        if (this.getAutomaton().getInitialState() == state) {
            return new Rectangle(point.x - n * 2, point.y - n, n * 3, n * 2 + n2);
        }
        return new Rectangle(point.x - n, point.y - n, n * 2, n * 2 + n2);
    }

    public Rectangle getBounds(Transition transition) {
        if (!this.valid) {
            this.refreshArrowMap();
        }
        CurvedArrow curvedArrow = (CurvedArrow)this.transitionToArrowMap.get(transition);
        Rectangle2D rectangle2D = curvedArrow.getBounds();
        return new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    public Rectangle getBounds() {
        Rectangle2D rectangle2D;
        State[] stateArray;
        if (this.validBounds) {
            return this.cachedBounds;
        }
        if (!this.valid) {
            this.refreshArrowMap();
        }
        if ((stateArray = this.getAutomaton().getStates()).length == 0) {
            return null;
        }
        Rectangle rectangle = this.getBounds(stateArray[0]);
        for (int i = 1; i < stateArray.length; ++i) {
            rectangle.add(this.getBounds(stateArray[i]));
        }
        ArrayList arrayList = this.getAutomaton().getNotes();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object = (Note)arrayList.get(i);
            rectangle2D = new Rectangle(((Note)object).getAutoPoint(), new Dimension(((Component)object).getBounds().getSize()));
            rectangle.add((Rectangle)rectangle2D);
        }
        for (Object object : this.arrowToTransitionMap.keySet()) {
            rectangle2D = ((CurvedArrow)object).getBounds();
            rectangle.add(rectangle2D);
        }
        this.validBounds = true;
        this.cachedBounds = this.curTransform.createTransformedShape(rectangle).getBounds();
        return this.cachedBounds;
    }

    protected void drawState(Graphics graphics, State state) {
        this.statedrawer.drawState(graphics, this.getAutomaton(), state);
        if (this.drawLabels) {
            this.statedrawer.drawStateLabel(graphics, state, state.getPoint(), StateDrawer.STATE_COLOR);
        }
    }

    protected void drawTransitions(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Set set = this.arrowToTransitionMap.keySet();
        for (CurvedArrow curvedArrow : set) {
            if (curvedArrow.myTransition.isSelected) {
                curvedArrow.drawHighlight(graphics2D);
                curvedArrow.drawControlPoint(graphics2D);
                continue;
            }
            curvedArrow.draw(graphics2D);
        }
    }

    protected void drawSelectionBox(Graphics graphics) {
        graphics.drawRect(this.mySelectionBounds.x, this.mySelectionBounds.y, this.mySelectionBounds.width, this.mySelectionBounds.height);
    }

    private void refreshArrowMap() {
        if (this.automaton == null) {
            return;
        }
        State[] stateArray = this.automaton.getStates();
        this.arrowToTransitionMap.clear();
        this.transitionToArrowMap.clear();
        for (int i = 0; i < stateArray.length; ++i) {
            Object object;
            Object object2;
            for (int j = i + 1; j < stateArray.length; ++j) {
                CurvedArrow curvedArrow;
                float f;
                int n;
                float f2;
                object2 = this.automaton.getTransitionsFromStateToState(stateArray[i], stateArray[j]);
                object = this.automaton.getTransitionsFromStateToState(stateArray[j], stateArray[i]);
                float f3 = ((Transition[])object).length > 0 ? 0.5f : 0.0f;
                float f4 = f2 = ((Transition[])object2).length > 0 ? 0.5f : 0.0f;
                if (((Transition[])object2).length + ((Transition[])object).length == 0) continue;
                double d = this.angle(stateArray[i], stateArray[j]);
                Point point = this.pointOnState(stateArray[i], d - 0.12566370614359174);
                Point point2 = this.pointOnState(stateArray[j], d + Math.PI + 0.12566370614359174);
                for (n = 0; n < ((Transition[])object2).length; ++n) {
                    if (this.curveTransitionMap.containsKey(object2[n])) {
                        f3 = this.curveTransitionMap.get(object2[n]).floatValue();
                    }
                    f = f3 + (float)n;
                    curvedArrow = n == 0 ? new CurvedArrow(point, point2, f, object2[n]) : new InvisibleCurvedArrow(point, point2, f, object2[n]);
                    curvedArrow.setLabel(object2[n].getDescription());
                    this.arrowToTransitionMap.put(curvedArrow, object2[n]);
                    this.transitionToArrowMap.put(object2[n], curvedArrow);
                }
                point = this.pointOnState(stateArray[i], d + 0.12566370614359174);
                point2 = this.pointOnState(stateArray[j], d + Math.PI - 0.12566370614359174);
                for (n = 0; n < ((Transition[])object).length; ++n) {
                    if (this.curveTransitionMap.containsKey(object[n])) {
                        f2 = this.curveTransitionMap.get(object[n]).floatValue();
                    }
                    f = f2 + (float)n;
                    curvedArrow = n == 0 ? new CurvedArrow(point2, point, f, object[n]) : new InvisibleCurvedArrow(point2, point, f, object[n]);
                    String string = object[n].getDescription();
                    curvedArrow.setLabel(string);
                    this.arrowToTransitionMap.put(curvedArrow, object[n]);
                    this.transitionToArrowMap.put(object[n], curvedArrow);
                }
            }
            Transition[] transitionArray = this.automaton.getTransitionsFromStateToState(stateArray[i], stateArray[i]);
            if (transitionArray.length == 0) continue;
            object2 = this.pointOnState(stateArray[i], -1.046150353645401);
            object = this.pointOnState(stateArray[i], -2.0954422999443922);
            for (int j = 0; j < transitionArray.length; ++j) {
                Object object3;
                if (this.selfTransitionMap.containsKey(transitionArray[j])) {
                    object3 = this.pointOnState(stateArray[i], this.selfTransitionMap.get(transitionArray[j]) + 0.5215043804959056);
                    Point point = this.pointOnState(stateArray[i], this.selfTransitionMap.get(transitionArray[j]) - 0.5215043804959056);
                    CurvedArrow curvedArrow = j == 0 ? new CurvedArrow((Point)object3, point, -2.0f, transitionArray[j]) : new InvisibleCurvedArrow((Point)object3, point, -2.0f - (float)j, transitionArray[j]);
                    curvedArrow.setLabel(transitionArray[j].getDescription());
                    this.arrowToTransitionMap.put(curvedArrow, transitionArray[j]);
                    this.transitionToArrowMap.put(transitionArray[j], curvedArrow);
                    continue;
                }
                this.selfTransitionMap.put(transitionArray[j], -1.5707963267948966);
                object3 = j == 0 ? new CurvedArrow((Point)object2, (Point)object, -2.0f, transitionArray[j]) : new InvisibleCurvedArrow((Point)object2, (Point)object, -2.0f - (float)j, transitionArray[j]);
                ((CurvedArrow)object3).myTransition = transitionArray[j];
                ((CurvedArrow)object3).setLabel(transitionArray[j].getDescription());
                this.arrowToTransitionMap.put(object3, transitionArray[j]);
                this.transitionToArrowMap.put(transitionArray[j], object3);
            }
        }
        this.valid = true;
    }

    protected Point getCenterIntersection(State state, State state2) {
        return this.pointOnState(state, this.angle(state, state2));
    }

    private double angle(State state, State state2) {
        Point point = state.getPoint();
        Point point2 = state2.getPoint();
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        return Math.atan2(d2, d);
    }

    public Point pointOnState(State state, double d) {
        Point point = new Point(state.getPoint());
        double d2 = Math.cos(d) * 20.0;
        double d3 = Math.sin(d) * 20.0;
        point.translate((int)d2, (int)d3);
        return point;
    }

    public void invalidate() {
        this.valid = false;
        this.invalidateBounds();
    }

    public void invalidateBounds() {
        this.validBounds = false;
    }

    public State stateAtPoint(Point point) {
        State[] stateArray = this.getAutomaton().getStates();
        for (int i = stateArray.length - 1; i >= 0; --i) {
            if (!(point.distance(stateArray[i].getPoint()) <= 20.0)) continue;
            return stateArray[i];
        }
        return null;
    }

    public Transition transitionAtPoint(Point point) {
        if (!this.valid) {
            this.refreshArrowMap();
        }
        Set set = this.arrowToTransitionMap.keySet();
        for (CurvedArrow curvedArrow : set) {
            if (!curvedArrow.isNear(point, 2)) continue;
            return (Transition)this.arrowToTransitionMap.get(curvedArrow);
        }
        return null;
    }

    public StateDrawer getStateDrawer() {
        return this.statedrawer;
    }

    protected void transitionChange(AutomataTransitionEvent automataTransitionEvent) {
        this.invalidate();
    }

    protected void stateChange(AutomataStateEvent automataStateEvent) {
        if (automataStateEvent.isMove()) {
            this.invalidate();
        } else {
            this.invalidateBounds();
        }
    }

    protected CurvedArrow arrowForTransition(Transition transition) {
        return (CurvedArrow)this.transitionToArrowMap.get(transition);
    }

    public boolean doesDrawStateLabels() {
        return this.drawLabels;
    }

    public void shouldDrawStateLabels(boolean bl) {
        this.drawLabels = bl;
    }

    public void setAutomaton(Automaton automaton) {
        if (automaton == null) {
            return;
        }
        this.automaton = automaton;
        this.invalidate();
    }

    public void setSelectionBounds(Rectangle rectangle) {
        this.mySelectionBounds = rectangle;
    }

    public Rectangle getSelectionBounds() {
        return this.mySelectionBounds;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.curTransform = affineTransform;
    }

    private class DrawerListener
    implements AutomataStateListener,
    AutomataTransitionListener {
        private DrawerListener() {
        }

        @Override
        public void automataTransitionChange(AutomataTransitionEvent automataTransitionEvent) {
            AutomatonDrawer.this.transitionChange(automataTransitionEvent);
        }

        @Override
        public void automataStateChange(AutomataStateEvent automataStateEvent) {
            AutomatonDrawer.this.stateChange(automataStateEvent);
        }
    }
}

