/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Configuration;
import automata.turing.TMConfiguration;
import automata.turing.Tape;
import gui.sim.ConfigurationIcon;
import gui.sim.Torn;
import gui.sim.TuringConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;

public class TMConfigurationIcon
extends ConfigurationIcon
implements TuringConstants {
    private TMConfiguration config;

    public TMConfigurationIcon(Configuration configuration) {
        super(configuration);
        this.config = (TMConfiguration)configuration;
    }

    @Override
    public int getIconHeight() {
        return super.getIconHeight() + 25 * this.config.getTapes().length;
    }

    @Override
    public void paintConfiguration(Component component, Graphics2D graphics2D, int n, int n2) {
        if (component != null) {
            super.paintConfiguration(component, graphics2D, n, n2);
        }
        float f = (float)TMConfigurationIcon.BELOW_STATE.y + 5.0f;
        int n3 = TMConfigurationIcon.BELOW_STATE.x + n / 2;
        int n4 = TMConfigurationIcon.BELOW_STATE.y + 5;
        Tape[] tapeArray = this.config.getTapes();
        for (int i = 0; i < tapeArray.length; ++i) {
            float f2 = Torn.paintString(graphics2D, FIX + tapeArray[i].getContents() + FIX, TMConfigurationIcon.BELOW_STATE.x, f, 0, n, true, true, tapeArray[i].getTapeHead() + FIX.length());
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(n3, n4, n3 - 4, n4 - 4);
            graphics2D.drawLine(n3, n4, n3 + 4, n4 - 4);
            f += f2 + 8.0f;
        }
        f -= 8.0f;
    }
}

