/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.Canvas;
import gui.pumping.CasePanel;
import gui.pumping.ComputerFirstPane;
import gui.pumping.HumanFirstPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import pumping.ContextFreePumpingLemma;
import pumping.PumpingLemma;

public abstract class PumpingLemmaInputPane
extends JPanel {
    protected static Dimension MAX_SIZE = new Dimension(640, 580);
    private static String PROMPT_ANIM = "Click \"Step\" in Box 5 to step the animation.";
    private static String PROMPT_CASE = "Click \"Step\" in Box 5 to step the animation or \"Add\" in the right panel to add this case.";
    protected PumpingLemma myLemma;
    protected JTextComponent myMDisplay;
    protected JTextComponent myWDisplay;
    protected JTextComponent myIDisplay;
    protected JTextArea myPumpedStringDisplay;
    protected Canvas myCanvas;
    protected JButton myStartAnimation;
    protected JButton myStepAnimation;
    protected JEditorPane myLastWord;
    private JTextPane myTopTextPane;
    protected CasePanel myCases;
    protected JPanel leftPanel;
    protected JPanel[] stages;
    protected JLabel[] stageMessages;

    public PumpingLemmaInputPane(PumpingLemma pumpingLemma, String string) {
        JComponent jComponent;
        this.setLayout(new BorderLayout());
        this.myLemma = pumpingLemma;
        JPanel jPanel = new JPanel(new BorderLayout());
        JEditorPane jEditorPane = new JEditorPane("text/html", "<html><body align=center><b>" + string + "</b></body></html>");
        jEditorPane.setBackground(this.getBackground());
        jEditorPane.setDisabledTextColor(Color.BLACK);
        jEditorPane.setEnabled(false);
        jPanel.add((Component)jEditorPane, "North");
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.initLeftPanel();
        if (this.myLemma.numCasesTotal() <= 1 || this instanceof ComputerFirstPane) {
            this.leftPanel.setPreferredSize(MAX_SIZE);
            this.leftPanel.setMaximumSize(MAX_SIZE);
            jPanel.add((Component)this.leftPanel, "Center");
        } else {
            jComponent = new JSplitPane(1);
            this.leftPanel.revalidate();
            this.leftPanel.setPreferredSize(new Dimension(400, 300));
            this.leftPanel.setMaximumSize(MAX_SIZE);
            ((JSplitPane)jComponent).setLeftComponent(this.leftPanel);
            JComponent jComponent2 = this.initRightPanel();
            jComponent2.setPreferredSize(new Dimension(400, 300));
            jComponent2.setMaximumSize(MAX_SIZE);
            ((JSplitPane)jComponent).setRightComponent(jComponent2);
            jPanel.add((Component)jComponent, "Center");
        }
        jComponent = new JScrollPane(jPanel);
        this.add((Component)jComponent, "Center");
        this.setMaximumSize(MAX_SIZE);
        this.setPreferredSize(MAX_SIZE);
    }

    private void initLeftPanel() {
        int n;
        this.stages = new JPanel[6];
        this.stageMessages = new JLabel[6];
        for (n = 0; n < this.stageMessages.length; ++n) {
            this.stageMessages[n] = new JLabel();
        }
        this.stages[0] = this.initTop();
        this.stages[1] = this.initM();
        this.stages[2] = this.initW();
        this.stages[3] = this.initDecompPanel();
        this.stages[4] = this.initI();
        this.stages[5] = this.initCanvas();
        for (n = 0; n < this.stages.length; ++n) {
            this.leftPanel.add(this.stages[n]);
        }
        if (this instanceof HumanFirstPane) {
            this.stages[2].setVisible(false);
        }
        for (n = 3; n < this.stages.length; ++n) {
            this.stages[n].setVisible(false);
        }
    }

    private JComponent initRightPanel() {
        this.myCases = new CasePanel((ContextFreePumpingLemma)this.myLemma, this);
        return new JScrollPane(this.myCases);
    }

    private JPanel initTop() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("Clear All");
        JButton jButton2 = new JButton("Explain");
        this.myTopTextPane = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane(this.myTopTextPane);
        this.myTopTextPane.setContentType("text/html");
        this.myTopTextPane.setEditable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PumpingLemmaInputPane.this.updateTopPane(true);
            }
        });
        String string = this.addTopGameFeatures(jButton);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder("Objective: " + string));
        jPanel.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        jPanel.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        return jPanel;
    }

    private JPanel initM() {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = this.addMGameFeatures();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.myMDisplay, "North");
        jPanel2.setBorder(BorderFactory.createTitledBorder("1. " + string));
        jPanel2.add((Component)this.stageMessages[1], "South");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        jPanel.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        return jPanel;
    }

    private JPanel initW() {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = this.addWGameFeatures();
        jPanel.setBorder(BorderFactory.createTitledBorder("2. " + string));
        jPanel.add((Component)this.myWDisplay, "North");
        jPanel.add((Component)this.stageMessages[2], "South");
        jPanel.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        jPanel.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        return jPanel;
    }

    protected abstract JPanel initDecompPanel();

    private JPanel initI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("i: "));
        String string = this.addIGameFeatures();
        jPanel2.add(this.myIDisplay);
        jPanel2.add(new JLabel("    pumped string: "));
        this.myPumpedStringDisplay = new JTextArea(1, 30);
        this.myPumpedStringDisplay.setEditable(false);
        jPanel2.add(this.myPumpedStringDisplay);
        jPanel.setBorder(BorderFactory.createTitledBorder("4. " + string));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add(jPanel2.add(this.stageMessages[4]), "South");
        jPanel.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        jPanel.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        return jPanel;
    }

    private JPanel initCanvas() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.myCanvas = new Canvas();
        jPanel.add((Component)this.myCanvas, "Center");
        this.myLastWord = new JEditorPane("text/html", "");
        this.myLastWord.setBackground(this.getBackground());
        this.myLastWord.setDisabledTextColor(Color.BLACK);
        this.myLastWord.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.myLastWord);
        this.myStepAnimation = new JButton("Step");
        this.myStepAnimation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PumpingLemmaInputPane.this.stepAnimation();
                PumpingLemmaInputPane.this.myCanvas.start();
            }
        });
        this.myStepAnimation.setEnabled(false);
        jPanel2.add(this.myStepAnimation);
        this.myCanvas.setStepButton(this.myStepAnimation);
        this.myStartAnimation = new JButton("Restart");
        this.myStartAnimation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PumpingLemmaInputPane.this.setCanvas();
                PumpingLemmaInputPane.this.myCanvas.stop();
                PumpingLemmaInputPane.this.repaint();
            }
        });
        this.myStartAnimation.setEnabled(false);
        jPanel2.add(this.myStartAnimation);
        this.myCanvas.setRestartButton(this.myStartAnimation);
        jPanel.add((Component)this.stageMessages[5], "North");
        jPanel.add((Component)jPanel2, "South");
        jPanel.setBorder(BorderFactory.createTitledBorder("5. Animation"));
        jPanel.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, 35 * PumpingLemmaInputPane.MAX_SIZE.height / 100));
        jPanel.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, 35 * PumpingLemmaInputPane.MAX_SIZE.height / 100));
        return jPanel;
    }

    protected void setVisibilityStages(int n, boolean bl) {
        for (int i = n; i < this.stages.length; ++i) {
            this.stages[i].setVisible(bl);
        }
    }

    protected void resetMessages() {
        for (int i = 0; i < this.stageMessages.length; ++i) {
            this.stageMessages[i].setText("");
        }
    }

    protected abstract void resetDecompPanel();

    protected void reset() {
        this.myLemma.reset();
        this.resetDecompPanel();
        this.resetMessages();
        if (this.myCases != null) {
            this.myCases.clearAll();
            this.myCases.setMessage("");
            this.myCases.setListButtonEnabled(false);
            this.myCases.setAddReplaceButtonsEnabled(false);
        }
        if (this instanceof HumanFirstPane) {
            this.setVisibilityStages(2, false);
        } else {
            this.setVisibilityStages(3, false);
        }
        this.leftPanel.revalidate();
    }

    public void updateTopPane(boolean bl) {
        String string = "<b>My Attempts:</b>";
        String string2 = "<html>";
        if (this.stageMessages[0].getText().length() > 0) {
            string2 = string2 + "<b><i>" + this.stageMessages[0].getText() + "</i></b><br>";
        }
        for (int i = this.myLemma.getAttempts().size() - 1; i >= 0; --i) {
            String string3 = (String)this.myLemma.getAttempts().get(i);
            string = string + "<br>" + (i + 1) + ":  " + string3;
        }
        if (bl) {
            String string4 = this.myLemma.getPartitionValidity() ? "<b>A valid partition of <i>w</i> exists!</b><br>" : "<b>Unfortunately no valid partition of <i>w</i> exists.</b><br>";
            string2 = this.myLemma.getAttempts().size() > 0 ? string2 + string4 + this.myLemma.getExplanation() + "<br><br>" : string2 + string4 + this.myLemma.getExplanation();
        }
        if (this.myLemma.getAttempts().size() > 0) {
            string2 = string2 + string;
        }
        string2 = string2 + "</html>";
        this.myTopTextPane.setText(string2);
        this.myTopTextPane.setCaretPosition(0);
    }

    protected abstract String addTopGameFeatures(JButton var1);

    protected abstract String addMGameFeatures();

    protected abstract String addWGameFeatures();

    protected abstract String addIGameFeatures();

    public void setDecomposition(int[] nArray, int n) {
        this.setDecomposition(nArray);
        this.myLemma.setDecomposition(nArray, n);
    }

    public abstract void setDecomposition(int[] var1);

    protected abstract void setCanvas();

    protected abstract String createXYZ();

    public void displayIEnd() {
        this.myIDisplay.setText(Integer.toString(this.myLemma.getI()));
        this.displayEnd();
    }

    public abstract void displayEnd();

    private void stepAnimation() {
        this.repaint();
    }

    public static String toHTMLString(String string) {
        if (string.length() < 2) {
            return string;
        }
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            for (int j = i + 1; j < string.length(); ++j) {
                if (string.substring(j, j + 1).equals(string.substring(i, i + 1))) {
                    ++n;
                } else {
                    stringBuffer.append("<i>");
                    stringBuffer.append(string.substring(i, i + 1));
                    stringBuffer.append("</i>");
                    if (n > 1) {
                        stringBuffer.append("<sup>");
                        stringBuffer.append("" + n);
                        stringBuffer.append("</sup>");
                    }
                    i = j;
                    n = 1;
                }
                if (j != string.length() - 1) continue;
                stringBuffer.append("<i>");
                stringBuffer.append(string.substring(string.length() - 1));
                stringBuffer.append("</i>");
                if (n > 1) {
                    stringBuffer.append("<sup>");
                    stringBuffer.append("" + n);
                    stringBuffer.append("</sup>");
                }
                return stringBuffer.toString();
            }
        }
        System.err.println("BUG FOUND: PumpingLemmaInputPane.toHTMLString(String)");
        System.err.println("String = " + string);
        return stringBuffer.toString();
    }

    public abstract void update();
}

