/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.PumpingLemmaInputPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pumping.Case;
import pumping.PumpingLemma;

public class CasePanel
extends JPanel {
    private static Dimension PREFERRED_SIZE = new Dimension(350, 480);
    private ArrayList myCases;
    private JTable myTable;
    private PumpingLemma myLemma;
    private int[] tempDecomposition;
    private int tempI;
    private JTextArea myMessage;
    private PumpingLemmaInputPane myPane;
    private JButton myShowAll;
    private JButton myClearAll;
    private JButton myClearCase;
    private JButton myShowCase;
    private JButton myAddCase;
    private JButton myDone;
    private JButton myReplace;

    public CasePanel(PumpingLemma pumpingLemma, PumpingLemmaInputPane pumpingLemmaInputPane) {
        this.myPane = pumpingLemmaInputPane;
        this.myLemma = pumpingLemma;
        this.myCases = new ArrayList();
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Cases:"), "North");
        this.add((Component)this.initTable(), "Center");
        this.add((Component)this.initButtons(), "South");
        this.setPreferredSize(PREFERRED_SIZE);
        this.refresh();
    }

    protected JComponent initTable() {
        this.myTable = new JTable(new AbstractTableModel(){
            public final String[] COLUMN_NAMES = new String[]{"#", "Description"};

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return Integer.toString(n + 1);
                }
                return CasePanel.this.myCases.get(n);
            }

            @Override
            public String getColumnName(int n) {
                return this.COLUMN_NAMES[n];
            }

            @Override
            public int getRowCount() {
                return CasePanel.this.myCases.size();
            }

            @Override
            public int getColumnCount() {
                return this.COLUMN_NAMES.length;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
            }
        });
        ListSelectionModel listSelectionModel = this.myTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        TableColumn tableColumn = this.myTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(25);
        JScrollPane jScrollPane = new JScrollPane(this.myTable);
        return jScrollPane;
    }

    protected JComponent initButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.myMessage = new JTextArea();
        this.myMessage.setEditable(false);
        jPanel.add(this.myMessage);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.myAddCase = new JButton("Add");
        this.myAddCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CasePanel.this.addCase();
            }
        });
        this.myAddCase.setToolTipText("Add the current case to the list");
        this.myAddCase.setEnabled(false);
        jPanel2.add(this.myAddCase);
        this.myReplace = new JButton("Replace");
        this.myReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CasePanel.this.replaceCase(CasePanel.this.myTable.getSelectedRow());
            }
        });
        this.myReplace.setToolTipText("Replace the selected case with the current case");
        this.myReplace.setEnabled(false);
        jPanel2.add(this.myReplace);
        this.myShowAll = new JButton("List");
        this.myShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CasePanel.this.listAll();
            }
        });
        this.myShowAll.setEnabled(false);
        this.myShowAll.setToolTipText("List all possible cases");
        jPanel3.add(this.myShowAll);
        this.myShowCase = new JButton("Show");
        this.myShowCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CasePanel.this.showCase(CasePanel.this.myTable.getSelectedRow());
            }
        });
        this.myShowCase.setEnabled(false);
        this.myShowCase.setToolTipText("Display the selected case");
        jPanel2.add(this.myShowCase);
        this.myClearCase = new JButton("Delete");
        this.myClearCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CasePanel.this.clearCase(CasePanel.this.myTable.getSelectedRow());
            }
        });
        this.myClearCase.setEnabled(false);
        this.myClearCase.setToolTipText("Delete the selected case");
        jPanel2.add(this.myClearCase);
        this.myClearAll = new JButton("Clear");
        this.myClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CasePanel.this.clearAll();
            }
        });
        this.myClearAll.setToolTipText("Clear all cases");
        jPanel3.add(this.myClearAll);
        this.myDone = new JButton("Done?");
        this.myDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CasePanel.this.myLemma.numCasesTotal() - CasePanel.this.myCases.size();
                if (n == 1) {
                    CasePanel.this.myMessage.setText("1 case left.");
                } else if (n > 1) {
                    CasePanel.this.myMessage.setText(n + " cases left.");
                } else {
                    CasePanel.this.myMessage.setText("All cases done.");
                }
            }
        });
        this.myDone.setToolTipText("Check if all cases are done");
        jPanel3.add(this.myDone);
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    CasePanel.this.myShowCase.setEnabled(false);
                    CasePanel.this.myClearCase.setEnabled(false);
                    CasePanel.this.myReplace.setEnabled(false);
                } else {
                    CasePanel.this.myShowCase.setEnabled(true);
                    CasePanel.this.myClearCase.setEnabled(true);
                    CasePanel.this.myReplace.setEnabled(CasePanel.this.myAddCase.isEnabled());
                }
            }
        });
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        return jScrollPane;
    }

    protected void listAll() {
        if (this.myCases.size() == this.myLemma.numCasesTotal()) {
            this.myMessage.setText("All cases for m = " + this.myLemma.getM() + " are already shown.");
        } else {
            this.myLemma.doAll();
            this.myMessage.setText("All cases for m = " + this.myLemma.getM() + " shown.");
            this.refresh();
        }
    }

    public void clearAll() {
        this.myLemma.clearDoneCases();
        this.myMessage.setText("All cases cleared.");
        this.refresh();
    }

    protected void clearCase(int n) {
        try {
            this.myLemma.clearCase(n);
            this.myCases.remove(n);
            this.myMessage.setText("Case #" + (n + 1) + " deleted.");
            this.refresh();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.myMessage.setText("Please select a case to clear.");
        }
    }

    protected void showCase(int n) {
        try {
            Case case_ = this.myLemma.getCase(n);
            if (case_.getI() != -1) {
                this.myPane.setDecomposition(case_.getInput(), case_.getI());
                this.myPane.displayIEnd();
                this.myPane.setVisibilityStages(4, true);
                this.myPane.setCanvas();
                this.setAddReplaceButtonsEnabled(true);
            } else {
                this.myPane.setDecomposition(case_.getInput());
                this.myPane.setVisibilityStages(4, false);
                this.setAddReplaceButtonsEnabled(false);
            }
            this.refresh();
            this.myTable.getSelectionModel().setSelectionInterval(n, n);
            this.myMessage.setText("Showing case #" + (n + 1) + ".");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.myMessage.setText("Please select a case to show.");
        }
    }

    protected void setDecomposition(int[] nArray) {
        this.tempDecomposition = nArray;
    }

    protected void setI(int n) {
        this.tempI = n;
    }

    protected void addCase() {
        this.addCase(this.tempDecomposition, this.tempI);
    }

    protected void replaceCase(int n) {
        if (this.myLemma.replaceCase(this.tempDecomposition, this.tempI, n)) {
            this.myMessage.setText("Case #" + (n + 1) + " replaced.");
        } else {
            this.myMessage.setText("Wrong case selected.");
        }
    }

    protected void addCase(int[] nArray, int n) {
        int n2 = this.myLemma.addCase(nArray, n);
        this.refresh();
        if (n2 == -1) {
            this.myMessage.setText("Illegal decomposition!");
            return;
        }
        if (n2 >= this.myCases.size()) {
            n2 = this.myCases.size() - 1;
            this.myMessage.setText("Case added.");
        } else {
            this.myMessage.setText("This case is similar to #" + (n2 + 1) + ".");
        }
        this.myTable.getSelectionModel().setSelectionInterval(n2, n2);
    }

    public void refresh() {
        this.myCases = this.myLemma.getDoneDescriptions();
        ((AbstractTableModel)this.myTable.getModel()).fireTableDataChanged();
        if (this.myCases.size() == 0) {
            this.myDone.setEnabled(false);
            this.myClearAll.setEnabled(false);
        } else {
            this.myDone.setEnabled(true);
            this.myClearAll.setEnabled(true);
        }
        this.repaint();
    }

    public void setListButtonEnabled(boolean bl) {
        this.myShowAll.setEnabled(bl);
    }

    public void setAddReplaceButtonsEnabled(boolean bl) {
        this.myAddCase.setEnabled(bl);
        if (this.myShowCase.isEnabled()) {
            this.myReplace.setEnabled(bl);
        }
    }

    protected void setMessage(String string) {
        this.myMessage.setText(string);
    }
}

