/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.fsa.MinimizeTreeNode;
import gui.TooltipAction;
import gui.minimize.MinimizeController;
import gui.tree.SelectTreeDrawer;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.tree.TreeNode;

class ControlPanel
extends JToolBar {
    private SelectTreeDrawer treeDrawer;
    private MinimizeController controller;
    private static final String NODE_ERROR = "Exactly one node must be selected!";
    TooltipAction setTerminalAction;
    TooltipAction autoPartitionAction;
    TooltipAction completeSubtreeAction;
    TooltipAction checkNodeAction;
    TooltipAction addChildAction;
    TooltipAction removeAction;
    TooltipAction finishAction;

    public ControlPanel(SelectTreeDrawer selectTreeDrawer, MinimizeController minimizeController) {
        this.treeDrawer = selectTreeDrawer;
        this.controller = minimizeController;
        this.initView();
    }

    private MinimizeTreeNode getNode() {
        TreeNode[] treeNodeArray = this.treeDrawer.getSelected();
        if (treeNodeArray.length != 1) {
            return null;
        }
        return (MinimizeTreeNode)treeNodeArray[0];
    }

    private void initView() {
        this.setTerminalAction = new TooltipAction("Set Terminal", "Begins the split of a group on a terminal."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MinimizeTreeNode minimizeTreeNode = ControlPanel.this.getNode();
                if (minimizeTreeNode == null) {
                    JOptionPane.showMessageDialog(ControlPanel.this, ControlPanel.NODE_ERROR);
                    return;
                }
                ControlPanel.this.controller.splitOnTerminal(minimizeTreeNode);
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.setTerminalAction);
        this.autoPartitionAction = new TooltipAction("Auto Partition", "Does the split of a group for you."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MinimizeTreeNode minimizeTreeNode = ControlPanel.this.getNode();
                if (minimizeTreeNode == null) {
                    JOptionPane.showMessageDialog(ControlPanel.this, ControlPanel.NODE_ERROR);
                    return;
                }
                ControlPanel.this.controller.splitWithoutInput(minimizeTreeNode);
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.autoPartitionAction);
        this.completeSubtreeAction = new TooltipAction("Complete Subtree", "Does the split of this group and any subgroups for you."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MinimizeTreeNode minimizeTreeNode = ControlPanel.this.getNode();
                if (minimizeTreeNode == null) {
                    JOptionPane.showMessageDialog(ControlPanel.this, ControlPanel.NODE_ERROR);
                    return;
                }
                ControlPanel.this.controller.splitSubtree(minimizeTreeNode);
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.completeSubtreeAction);
        this.checkNodeAction = new TooltipAction("Check Node", "Verifies that a split of a group is correct."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.controller.check();
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.checkNodeAction);
        this.addChildAction = new TooltipAction("Add Child", "Adds a new partition a group being split."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.controller.addChild();
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.addChildAction);
        this.removeAction = new TooltipAction("Remove", "Removes a partition from a group being split."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeNode[] treeNodeArray = ControlPanel.this.treeDrawer.getSelected();
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    ControlPanel.this.controller.removeNode((MinimizeTreeNode)treeNodeArray[i]);
                }
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.removeAction);
        this.finishAction = new TooltipAction("Finish", "If the tree is done, begins building the automaton."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.controller.finished();
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.finishAction);
    }
}

