/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import grammar.Grammar;
import grammar.Production;
import grammar.ProductionComparator;
import gui.SplitPaneFactory;
import gui.action.GrammarTransformAction;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.editor.TransitionTool;
import gui.environment.FrameFactory;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.UselessController;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UselessPane
extends JPanel {
    GrammarEnvironment environment;
    Grammar grammar;
    UselessController controller;
    GrammarTable grammarTable;
    JLabel mainLabel = new JLabel(" ");
    JLabel detailLabel = new JLabel(" ");
    JLabel terminalLabel = new JLabel(" ");
    EditorPane vdgEditor;
    SelectionDrawer vdgDrawer;
    AbstractAction doStepAction = new AbstractAction("Do Step"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UselessPane.this.controller.doStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UselessPane.this.controller.doAll();
        }
    };
    AbstractAction proceedAction = new AbstractAction("Proceed"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Grammar grammar = UselessPane.this.getGrammar();
            if (grammar == null) {
                JOptionPane.showMessageDialog(UselessPane.this.environment, "The grammar is empty.  Cannot proceed.", "Bad Grammar", 0);
                return;
            }
            GrammarTransformAction.hypothesizeChomsky(UselessPane.this.environment, UselessPane.this.getGrammar());
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Grammar grammar = UselessPane.this.getGrammar();
            if (grammar == null) {
                JOptionPane.showMessageDialog(UselessPane.this.environment, "The grammar is empty.  Cannot proceed.", "Bad Grammar", 0);
                return;
            }
            FrameFactory.createFrame(UselessPane.this.getGrammar());
        }
    };
    boolean editingActive = false;
    private int editingRow = -1;
    private boolean[] editingColumn = new boolean[2];
    GrammarTableModel editingGrammarModel = new GrammarTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    GrammarTable editingGrammarView = new GrammarTable(this.editingGrammarModel);
    AbstractAction deleteAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UselessPane.this.deleteActivated();
        }
    };

    public UselessPane(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        this.environment = grammarEnvironment;
        this.grammar = grammar;
        this.controller = new UselessController(this, grammar);
        this.initView();
    }

    private void initView() {
        super.setLayout(new BorderLayout());
        this.initGrammarTable();
        JPanel jPanel = this.initRightPanel();
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.environment, true, 0.4, new JScrollPane(this.grammarTable), jPanel);
        this.add((Component)jSplitPane, "Center");
    }

    private JPanel initRightPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mainLabel.setAlignmentX(0.0f);
        this.detailLabel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.mainLabel);
        jPanel2.add(this.detailLabel);
        jPanel2.add(this.terminalLabel);
        this.initEditingGrammarTable();
        this.vdgDrawer = new SelectionDrawer(this.controller.vdg);
        this.vdgEditor = new EditorPane(this.vdgDrawer, new ToolBox(){

            @Override
            public List tools(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
                LinkedList<Tool> linkedList = new LinkedList<Tool>();
                linkedList.add(new ArrowNontransitionTool(automatonPane, automatonDrawer));
                linkedList.add(new TransitionTool(automatonPane, automatonDrawer));
                return linkedList;
            }
        }, true);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setAlignmentX(0.0f);
        jToolBar.setFloatable(false);
        jToolBar.add(this.deleteAction);
        jPanel3.add((Component)jToolBar, "North");
        jPanel3.add((Component)new JScrollPane(this.editingGrammarView), "Center");
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.environment, false, 0.5, this.vdgEditor, jPanel3);
        jPanel2.add(jSplitPane);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setAlignmentX(0.0f);
        jToolBar2.add(this.doStepAction);
        jToolBar2.add(this.doAllAction);
        jToolBar2.addSeparator();
        jToolBar2.add(this.proceedAction);
        jToolBar2.add(this.exportAction);
        jPanel.add((Component)jToolBar2, "North");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private GrammarTable initGrammarTable() {
        this.grammarTable = new GrammarTable(new GrammarTableModel(this.grammar){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        this.grammarTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Point point;
                GrammarTable grammarTable = (GrammarTable)mouseEvent.getSource();
                int n = grammarTable.rowAtPoint(point = mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                if (n == grammarTable.getGrammarModel().getRowCount() - 1) {
                    return;
                }
                Production production = grammarTable.getGrammarModel().getProduction(n);
                UselessPane.this.controller.productionClicked(production, mouseEvent);
            }
        });
        return this.grammarTable;
    }

    void updateDeleteEnabledness() {
        if (this.controller.step != 3) {
            this.deleteAction.setEnabled(false);
            return;
        }
        int n = this.editingGrammarView.getSelectionModel().getMinSelectionIndex();
        if (n == -1 || n >= this.editingGrammarModel.getRowCount() - 1) {
            this.deleteAction.setEnabled(false);
            return;
        }
        this.deleteAction.setEnabled(true);
    }

    private void initEditingGrammarTable() {
        this.editingGrammarView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                UselessPane.this.updateDeleteEnabledness();
            }
        });
        Object object = new Object();
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(8, 0), object);
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(127, 0), object);
        this.editingGrammarView.getActionMap().put(object, this.deleteAction);
    }

    private void deleteActivated() {
        if (this.controller.step != 3) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (int i = this.editingGrammarModel.getRowCount() - 2; i >= 0; --i) {
            if (!this.editingGrammarView.isRowSelected(i)) continue;
            Production production = this.editingGrammarModel.getProduction(i);
            if (this.controller.productionDeleted(production, i)) {
                this.editingGrammarModel.deleteRow(i);
                ++n;
                continue;
            }
            ++n2;
        }
        if (n2 != 0) {
            JOptionPane.showMessageDialog(this, n2 + " production(s) selected should not be removed.\n" + n + " production(s) were removed.", "Bad Selection", 0);
        }
        if (n != 0) {
            this.controller.updateDisplay();
        }
    }

    public Grammar getGrammar() {
        Grammar grammar = this.editingGrammarView.getGrammar(this.grammar.getClass());
        Production[] productionArray = grammar.getProductions();
        Arrays.sort(productionArray, new ProductionComparator(this.grammar));
        if (productionArray.length == 0 || !productionArray[0].getLHS().equals(this.grammar.getStartVariable())) {
            return null;
        }
        Grammar grammar2 = null;
        try {
            grammar2 = (Grammar)grammar.getClass().newInstance();
            grammar2.addProductions(productionArray);
            grammar2.setStartVariable(this.grammar.getStartVariable());
        }
        catch (Throwable throwable) {
            System.err.println("BADNESS!");
            System.err.println(throwable);
            return grammar2;
        }
        return grammar2;
    }
}

