/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.Production;
import gui.SplitPaneFactory;
import gui.environment.FrameFactory;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;

public class ChomskyPane
extends JPanel {
    GrammarEnvironment environment;
    Grammar grammar;
    CNFConverter converter;
    private int[] need = new int[0];
    GrammarTable grammarTable;
    GrammarTableModel editingGrammarModel = new GrammarTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    GrammarTable editingGrammarView = new GrammarTable(this.editingGrammarModel);
    JLabel mainLabel = new JLabel(" ");
    JLabel directionLabel = new JLabel(" ");
    AbstractAction convertAction = new AbstractAction("Convert Selected"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChomskyPane.this.convertSelected();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChomskyPane.this.doAll();
        }
    };
    AbstractAction highlightAction = new AbstractAction("What's Left?"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChomskyPane.this.highlightRemaining();
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChomskyPane.this.export();
        }
    };

    public ChomskyPane(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        this.environment = grammarEnvironment;
        this.grammar = grammar;
        this.converter = new CNFConverter(grammar);
        this.mainLabel.setText("Welcome to the Chomsky converter.");
        this.mainLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 10) {
                    ChomskyPane.this.mainLabel.setText("Click on me again, and I'll kick your ass.");
                }
            }
        });
        this.initView();
        this.updateDisplay();
    }

    private void initView() {
        super.setLayout(new BorderLayout());
        this.initGrammarTable();
        JPanel jPanel = this.initRightPanel();
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.environment, true, 0.4, new JScrollPane(this.grammarTable), jPanel);
        this.add((Component)jSplitPane, "Center");
    }

    private JPanel initRightPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.initEditingGrammarTable();
        this.mainLabel.setAlignmentX(0.0f);
        this.directionLabel.setAlignmentX(0.0f);
        jPanel.add(this.mainLabel);
        jPanel.add(this.directionLabel);
        jPanel.add(new JScrollPane(this.editingGrammarView));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.convertAction);
        jToolBar.add(this.doAllAction);
        jToolBar.add(this.highlightAction);
        jToolBar.addSeparator();
        jToolBar.add(this.exportAction);
        jPanel2.add((Component)jToolBar, "North");
        return jPanel2;
    }

    private void updateDisplay() {
        this.need = this.getWhatNeedsDone();
        boolean bl = this.need.length == 0;
        this.convertAction.setEnabled(!bl);
        this.doAllAction.setEnabled(!bl);
        this.highlightAction.setEnabled(!bl);
        this.exportAction.setEnabled(bl);
        if (bl) {
            this.directionLabel.setText("Conversion done.  Press \"Export\" to use.");
        } else {
            this.directionLabel.setText(this.need.length + " production(s) must be converted.");
        }
    }

    private int[] getWhatNeedsDone() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.editingGrammarModel.getRowCount() - 1; ++i) {
            if (this.converter.isChomsky(this.editingGrammarModel.getProduction(i))) continue;
            arrayList.add(new Integer(i));
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public void doAll() {
        ListSelectionModel listSelectionModel = this.editingGrammarView.getSelectionModel();
        while (this.need.length != 0) {
            listSelectionModel.clearSelection();
            for (int i = 0; i < this.need.length; ++i) {
                listSelectionModel.addSelectionInterval(this.need[i], this.need[i]);
            }
            this.convertSelected();
        }
        this.mainLabel.setText("All productions completed.");
        this.editingGrammarView.dehighlight();
    }

    private void highlightRemaining() {
        this.editingGrammarView.dehighlight();
        this.mainLabel.setText("Productions to convert are selected.");
        for (int i = 0; i < this.need.length; ++i) {
            this.editingGrammarView.highlight(this.need[i]);
        }
    }

    private void export() {
        Production[] productionArray = this.editingGrammarModel.getProductions();
        try {
            productionArray = CNFConverter.convert(productionArray);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            JOptionPane.showMessageDialog(this, unsupportedOperationException.getMessage(), "Export Error", 0);
            return;
        }
        try {
            Grammar grammar = (Grammar)this.grammar.getClass().newInstance();
            grammar.addProductions(productionArray);
            grammar.setStartVariable(this.grammar.getStartVariable());
            FrameFactory.createFrame(grammar);
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
    }

    public Grammar getGrammar() {
        Production[] productionArray = this.editingGrammarModel.getProductions();
        try {
            productionArray = CNFConverter.convert(productionArray);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            JOptionPane.showMessageDialog(this, unsupportedOperationException.getMessage(), "CNF Conversion Error", 0);
            return null;
        }
        try {
            Grammar grammar = (Grammar)this.grammar.getClass().newInstance();
            grammar.addProductions(productionArray);
            grammar.setStartVariable(this.grammar.getStartVariable());
            return grammar;
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            return null;
        }
    }

    private void convertSelected() {
        int n;
        if (!this.convertAction.isEnabled()) {
            return;
        }
        int[] nArray = this.editingGrammarView.getSelectedRows();
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.editingGrammarView.dehighlight();
        for (n = nArray.length - 1; n >= 0; --n) {
            Production production = this.editingGrammarModel.getProduction(nArray[n]);
            if (production == null) {
                return;
            }
            Production[] productionArray = null;
            try {
                productionArray = this.converter.replacements(production);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ++n2;
                continue;
            }
            this.editingGrammarModel.deleteRow(nArray[n]);
            for (int i = productionArray.length - 1; i >= 0; --i) {
                this.editingGrammarModel.addProduction(productionArray[i], nArray[n]);
                Integer n3 = new Integer(nArray[n]);
                arrayList.add(0, n3);
            }
        }
        if (n2 > 0) {
            JOptionPane.showMessageDialog(this, "Conversion unneeded on " + n2 + " production(s).\n" + (nArray.length - n2) + " production(s) converted.", "Conversion Unneeded", 0);
        }
        n = -1;
        int n4 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n5 = (Integer)arrayList.get(i) + i;
            if (n != -1 && n != n5 - 1) {
                ++n4;
            }
            n = n5;
            this.editingGrammarView.highlight(n5 -= n4);
        }
        if (arrayList.size() != 0) {
            this.editingGrammarView.repaint();
            this.mainLabel.setText("Replacement production(s) highlighted.");
        }
        this.updateDisplay();
    }

    private void initEditingGrammarTable() {
        this.editingGrammarView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ChomskyPane.this.convertSelected();
                }
            }
        });
        Production[] productionArray = this.grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            this.editingGrammarModel.addProduction(productionArray[i]);
        }
    }

    private GrammarTable initGrammarTable() {
        this.grammarTable = new GrammarTable(new GrammarTableModel(this.grammar){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        return this.grammarTable;
    }
}

