/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.tree.DefaultTreeDrawer;
import gui.tree.LeafNodePlacer;
import gui.tree.TreePanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

abstract class ParsePane
extends JPanel {
    JTextField inputDisplay = new JTextField();
    JTextField stackDisplay = new JTextField();
    JLabel statusDisplay = new JLabel("Input a string to begin.");
    public JTextField inputField = new JTextField();
    public Grammar grammar;
    GrammarTable grammarTable;
    GrammarEnvironment environment;
    public AbstractAction stepAction = new AbstractAction("Step"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParsePane.this.step();
        }
    };
    AbstractAction startAction = new AbstractAction("Start"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParsePane.this.input(ParsePane.this.inputField.getText());
        }
    };
    DefaultTreeDrawer treeDrawer = new DefaultTreeDrawer(new DefaultTreeModel(new DefaultMutableTreeNode())){
        private final Color INNER;
        private final Color LEAF;
        {
            this.INNER = new Color(100, 200, 120);
            this.LEAF = new Color(255, 255, 100);
        }

        @Override
        protected Color getNodeColor(TreeNode treeNode) {
            return treeNode.isLeaf() ? this.LEAF : this.INNER;
        }
    };
    JComponent treePanel = new TreePanel(this.treeDrawer);
    DefaultTableModel derivationModel = new DefaultTableModel(new String[]{"Production", "Derivation"}, 0){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    JSplitPane mainSplit;
    JSplitPane topSplit;
    JSplitPane bottomSplit;
    CardLayout treeDerivationLayout = new CardLayout();
    public JPanel treeDerivationPane = new JPanel(this.treeDerivationLayout);
    JScrollPane derivationPane;

    public ParsePane(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        super(new BorderLayout());
        this.grammar = grammar;
        this.environment = grammarEnvironment;
    }

    protected void initView() {
        this.treePanel = this.initTreePanel();
        JTable jTable = this.initParseTable();
        JScrollPane jScrollPane = jTable == null ? null : new JScrollPane(jTable);
        GrammarTable grammarTable = this.initGrammarTable(this.grammar);
        JScrollPane jScrollPane2 = new JScrollPane(grammarTable);
        this.treeDerivationPane.add((Component)this.initTreePanel(), "0");
        this.derivationPane = new JScrollPane(this.initDerivationTable());
        this.treeDerivationPane.add((Component)this.derivationPane, "1");
        this.bottomSplit = SplitPaneFactory.createSplit(this.environment, true, 0.3, jScrollPane2, this.treeDerivationPane);
        this.topSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, jScrollPane, this.initInputPanel());
        this.mainSplit = SplitPaneFactory.createSplit(this.environment, false, 0.3, this.topSplit, this.bottomSplit);
        this.add((Component)this.mainSplit, "Center");
        this.add((Component)this.statusDisplay, "South");
        this.add((Component)new TableTextSizeSlider(grammarTable), "North");
    }

    protected GrammarTable initGrammarTable(Grammar grammar) {
        this.grammarTable = new GrammarTable(new GrammarTableModel(grammar){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                try {
                    int n = this.rowAtPoint(mouseEvent.getPoint());
                    return this.getGrammarModel().getProduction(n).toString() + " is production " + n;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        return this.grammarTable;
    }

    protected JPanel initInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new JLabel("Input"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.inputField, gridBagConstraints);
        this.inputField.addActionListener(this.startAction);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)new JLabel("Input Remaining"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.inputDisplay.setEditable(false);
        jPanel2.add((Component)this.inputDisplay, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)new JLabel("Stack"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.stackDisplay.setEditable(false);
        jPanel2.add((Component)this.stackDisplay, gridBagConstraints);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this.initInputToolbar(), "North");
        return jPanel;
    }

    protected String[] getViewChoices() {
        return new String[]{"Noninverted Tree", "Inverted Tree", "Derivation Table"};
    }

    protected JToolBar initInputToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.startAction);
        this.stepAction.setEnabled(false);
        jToolBar.add(this.stepAction);
        jToolBar.addSeparator();
        final JComboBox<String> jComboBox = new JComboBox<String>(this.getViewChoices());
        jComboBox.setSelectedIndex(0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParsePane.this.changeView((String)jComboBox.getSelectedItem());
            }
        };
        jComboBox.addActionListener(actionListener);
        jToolBar.add(jComboBox);
        return jToolBar;
    }

    protected void changeView(String string) {
        if (string.equals("Noninverted Tree")) {
            this.treeDerivationLayout.first(this.treeDerivationPane);
            this.treeDrawer.setInverted(false);
            this.treePanel.repaint();
        } else if (string.equals("Inverted Tree")) {
            this.treeDerivationLayout.first(this.treeDerivationPane);
            this.treeDrawer.setInverted(true);
            this.treePanel.repaint();
        } else if (string.equals("Derivation Table")) {
            this.treeDerivationLayout.last(this.treeDerivationPane);
        }
    }

    protected abstract JTable initParseTable();

    protected JComponent initTreePanel() {
        this.treeDrawer.hideAll();
        this.treeDrawer.setNodePlacer(new LeafNodePlacer());
        return this.treePanel;
    }

    protected JTable initDerivationTable() {
        JTable jTable = new JTable(this.derivationModel);
        jTable.setGridColor(Color.lightGray);
        return jTable;
    }

    protected abstract void input(String var1);

    protected abstract boolean step();

    @Override
    public void printComponent(Graphics graphics) {
        this.treeDerivationPane.print(graphics);
    }

    @Override
    public void printChildren(Graphics graphics) {
    }
}

