/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import gui.environment.Universe;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class FirstFollowModel
extends AbstractTableModel {
    private String[] variables;
    private String[] terminals;
    private String[] firstSets;
    private String[] followSets;
    private boolean[] canEditColumn = new boolean[]{false, false, false};
    public static String LAMBDA = Universe.curProfile.getEmptyString();
    public static String[] COLUMN_NAMES = new String[]{" ", "FIRST", "FOLLOW"};

    public FirstFollowModel(Grammar grammar) {
        this.variables = grammar.getVariables();
        Arrays.sort(this.variables);
        this.terminals = grammar.getTerminals();
        this.firstSets = new String[this.variables.length];
        this.followSets = new String[this.variables.length];
        Arrays.fill(this.firstSets, "");
        Arrays.fill(this.followSets, "");
    }

    public Map getFirst() {
        return null;
    }

    public Map getFollow() {
        return null;
    }

    public void setCanEditFirst(boolean bl) {
        this.canEditColumn[1] = bl;
    }

    public void setCanEditFollow(boolean bl) {
        this.canEditColumn[2] = bl;
    }

    @Override
    public int getRowCount() {
        return this.variables.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.variables[n];
            }
            case 1: {
                return this.firstSets[n];
            }
            case 2: {
                return this.followSets[n];
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.canEditColumn[n2];
    }

    public Set getSet(int n, int n2) {
        String string = (String)this.getValueAt(n, n2);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '!') {
                treeSet.add("");
                continue;
            }
            treeSet.add(string.substring(i, i + 1));
        }
        return treeSet;
    }

    private String removeDuplicateCharacters(String string) {
        HashSet<Character> hashSet = new HashSet<Character>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            Character c = new Character(string.charAt(i));
            if (!hashSet.add(c)) continue;
            stringBuffer.append(c.charValue());
        }
        return stringBuffer.toString();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                this.variables[n] = (String)object;
                break;
            }
            case 1: {
                this.firstSets[n] = this.removeDuplicateCharacters((String)object);
                break;
            }
            case 2: {
                this.followSets[n] = this.removeDuplicateCharacters((String)object);
            }
        }
    }

    public void setSet(Set set, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : set) {
            if (string.length() == 0) {
                string = "!";
            }
            stringBuffer.append(string);
        }
        this.setValueAt(stringBuffer.toString(), n, n2);
    }
}

