/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.automata;

import automata.State;
import automata.Transition;
import automata.pda.PDAToCFGConverter;
import automata.pda.PushdownAutomaton;
import grammar.Grammar;
import grammar.Production;
import grammar.cfg.ContextFreeGrammar;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.GrammarCreationException;
import gui.viewer.SelectionDrawer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class PDAConvertController
extends ConvertController {
    private PDAToCFGConverter converter = new PDAToCFGConverter();

    public PDAConvertController(ConvertPane convertPane, SelectionDrawer selectionDrawer, PushdownAutomaton pushdownAutomaton) {
        super(convertPane, selectionDrawer, pushdownAutomaton);
        this.converter.initializeConverter();
        this.fillMap();
    }

    @Override
    protected Production[] getProductions(State state) {
        return new Production[0];
    }

    @Override
    protected Production[] getProductions(Transition transition) {
        return this.converter.createProductionsForTransition(transition, this.getAutomaton()).toArray(new Production[0]);
    }

    @Override
    protected Grammar getGrammar() {
        int n = this.getModel().getProductions().length;
        this.converter.purgeProductions(this.getAutomaton(), this.getModel());
        if (n != this.getModel().getProductions().length && this.converter.numberVariables() > 26) {
            throw new GrammarCreationException("Your list of rules has been trimmed, but there are still more variables than can be uniquely represented.");
        }
        if (this.converter.numberVariables() > 26) {
            throw new GrammarCreationException("There are more variables than can be uniquely represented.");
        }
        if (n != this.getModel().getProductions().length) {
            JOptionPane.showMessageDialog(null, "Your list of rules has been trimmed.");
        }
        int n2 = this.getModel().getRowCount();
        ContextFreeGrammar contextFreeGrammar = new ContextFreeGrammar();
        contextFreeGrammar.setStartVariable("S");
        ArrayList<Production> arrayList = new ArrayList<Production>();
        for (int i = 0; i < n2; ++i) {
            Production production = this.getModel().getProduction(i);
            if (production == null) continue;
            production = this.converter.getSimplifiedProduction(production);
            arrayList.add(production);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Production production = (Production)object;
                Production production2 = (Production)object2;
                if ("S".equals(production.getLHS())) {
                    if (production.getLHS().equals(production2.getLHS())) {
                        return 0;
                    }
                    return -1;
                }
                if ("S".equals(production2.getLHS())) {
                    return 1;
                }
                return production2.getLHS().compareTo(production.getRHS());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            contextFreeGrammar.addProduction((Production)iterator.next());
        }
        return contextFreeGrammar;
    }
}

