/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar;

import grammar.Grammar;
import grammar.TuringChecker;
import grammar.cfg.ContextFreeGrammar;
import grammar.reg.RegularGrammar;
import gui.TableTextSizeSlider;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class GrammarInputPane
extends JPanel {
    private GrammarTable table;
    private GrammarTableModel model;

    public GrammarInputPane() {
        this.model = new GrammarTableModel();
        this.initView();
    }

    public GrammarInputPane(Grammar grammar) {
        this.model = new GrammarTableModel(grammar);
        if (grammar.isConverted() || TuringChecker.check(grammar)) {
            this.initLargerView();
        } else {
            this.initView();
        }
    }

    private void initLargerView() {
        this.table = new GrammarTable(this.model);
        this.table.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.table.getColumnModel().getColumn(2);
        tableColumn.setHeaderValue("LHS");
        this.table.getTableHeader().resizeAndRepaint();
        tableColumn3.setHeaderValue("RHS");
        this.table.getTableHeader().resizeAndRepaint();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    private void initView() {
        this.table = new GrammarTable(this.model);
        this.table.setTableHeader(new JTableHeader(this.table.getColumnModel()));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setResizingAllowed(true);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.table.getColumnModel().getColumn(2);
        tableColumn.setHeaderValue("LHS");
        this.table.getTableHeader().resizeAndRepaint();
        tableColumn3.setHeaderValue("RHS");
        this.table.getTableHeader().resizeAndRepaint();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(70);
        tableColumn.setMaxWidth(200);
        tableColumn2.setMaxWidth(30);
        tableColumn2.setMinWidth(30);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)new TableTextSizeSlider(this.table), "North");
    }

    public Grammar getGrammar() {
        return this.getGrammar(ContextFreeGrammar.class);
    }

    public Grammar getGrammar(Class clazz) {
        return this.table.getGrammar(clazz);
    }

    public RegularGrammar getRegularGrammar() {
        return (RegularGrammar)this.getGrammar(RegularGrammar.class);
    }

    public GrammarTable getTable() {
        return this.table;
    }
}

