/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import automata.Automaton;
import automata.mealy.MealyMachine;
import automata.mealy.MooreMachine;
import grammar.ConvertedUnrestrictedGrammar;
import grammar.Grammar;
import grammar.lsystem.LSystem;
import gui.editor.EditorPane;
import gui.editor.MealyToolBox;
import gui.editor.MooreToolBox;
import gui.editor.ToolBox;
import gui.environment.AutomatonEnvironment;
import gui.environment.Environment;
import gui.environment.GrammarEnvironment;
import gui.environment.LSystemEnvironment;
import gui.environment.PumpingLemmaEnvironment;
import gui.environment.RegularEnvironment;
import gui.environment.tag.CriticalTag;
import gui.environment.tag.EditorTag;
import gui.environment.tag.PermanentTag;
import gui.environment.tag.Tag;
import gui.grammar.GrammarInputPane;
import gui.lsystem.LSystemInputPane;
import gui.pumping.CFPumpingLemmaChooser;
import gui.pumping.CompCFPumpingLemmaInputPane;
import gui.pumping.CompRegPumpingLemmaInputPane;
import gui.pumping.HumanCFPumpingLemmaInputPane;
import gui.pumping.HumanRegPumpingLemmaInputPane;
import gui.pumping.PumpingLemmaChooserPane;
import gui.pumping.PumpingLemmaInputPane;
import gui.pumping.RegPumpingLemmaChooser;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JOptionPane;
import pumping.ContextFreePumpingLemma;
import pumping.RegularPumpingLemma;
import regular.RegularExpression;

public class EnvironmentFactory {
    private static final Tag EDITOR_PERMANENT_TAG = new EditorPermanentTag();
    private static final String EDITOR_NAME = "Editor";

    public static Environment getEnvironment(Serializable serializable) {
        if (serializable instanceof RegularPumpingLemma) {
            RegPumpingLemmaChooser regPumpingLemmaChooser = new RegPumpingLemmaChooser();
            PumpingLemmaEnvironment pumpingLemmaEnvironment = new PumpingLemmaEnvironment(regPumpingLemmaChooser);
            PumpingLemmaChooserPane pumpingLemmaChooserPane = new PumpingLemmaChooserPane(regPumpingLemmaChooser, pumpingLemmaEnvironment);
            pumpingLemmaEnvironment.add((Component)pumpingLemmaChooserPane, "Select a Pumping Lemma", EDITOR_PERMANENT_TAG);
            RegularPumpingLemma regularPumpingLemma = (RegularPumpingLemma)serializable;
            PumpingLemmaInputPane pumpingLemmaInputPane = regularPumpingLemma.getFirstPlayer().equals("Computer") ? new CompRegPumpingLemmaInputPane(regularPumpingLemma) : new HumanRegPumpingLemmaInputPane(regularPumpingLemma);
            pumpingLemmaInputPane.update();
            regPumpingLemmaChooser.replace(regularPumpingLemma);
            pumpingLemmaEnvironment.add((Component)pumpingLemmaInputPane, "Pumping Lemma", new CriticalTag(){});
            pumpingLemmaEnvironment.setActive(pumpingLemmaInputPane);
            return pumpingLemmaEnvironment;
        }
        if (serializable instanceof ContextFreePumpingLemma) {
            CFPumpingLemmaChooser cFPumpingLemmaChooser = new CFPumpingLemmaChooser();
            PumpingLemmaEnvironment pumpingLemmaEnvironment = new PumpingLemmaEnvironment(cFPumpingLemmaChooser);
            PumpingLemmaChooserPane pumpingLemmaChooserPane = new PumpingLemmaChooserPane(cFPumpingLemmaChooser, pumpingLemmaEnvironment);
            pumpingLemmaEnvironment.add((Component)pumpingLemmaChooserPane, "Select a Pumping Lemma", EDITOR_PERMANENT_TAG);
            ContextFreePumpingLemma contextFreePumpingLemma = (ContextFreePumpingLemma)serializable;
            PumpingLemmaInputPane pumpingLemmaInputPane = contextFreePumpingLemma.getFirstPlayer().equals("Computer") ? new CompCFPumpingLemmaInputPane(contextFreePumpingLemma) : new HumanCFPumpingLemmaInputPane(contextFreePumpingLemma);
            pumpingLemmaInputPane.update();
            cFPumpingLemmaChooser.replace(contextFreePumpingLemma);
            pumpingLemmaEnvironment.add((Component)pumpingLemmaInputPane, "Pumping Lemma", new CriticalTag(){});
            pumpingLemmaEnvironment.setActive(pumpingLemmaInputPane);
            return pumpingLemmaEnvironment;
        }
        if (serializable instanceof RegPumpingLemmaChooser) {
            RegPumpingLemmaChooser regPumpingLemmaChooser = (RegPumpingLemmaChooser)serializable;
            PumpingLemmaEnvironment pumpingLemmaEnvironment = new PumpingLemmaEnvironment(regPumpingLemmaChooser);
            PumpingLemmaChooserPane pumpingLemmaChooserPane = new PumpingLemmaChooserPane(regPumpingLemmaChooser, pumpingLemmaEnvironment);
            pumpingLemmaEnvironment.add((Component)pumpingLemmaChooserPane, "Select a Pumping Lemma", EDITOR_PERMANENT_TAG);
            return pumpingLemmaEnvironment;
        }
        if (serializable instanceof CFPumpingLemmaChooser) {
            CFPumpingLemmaChooser cFPumpingLemmaChooser = (CFPumpingLemmaChooser)serializable;
            PumpingLemmaEnvironment pumpingLemmaEnvironment = new PumpingLemmaEnvironment(cFPumpingLemmaChooser);
            PumpingLemmaChooserPane pumpingLemmaChooserPane = new PumpingLemmaChooserPane(cFPumpingLemmaChooser, pumpingLemmaEnvironment);
            pumpingLemmaEnvironment.add((Component)pumpingLemmaChooserPane, "Select a Pumping Lemma", EDITOR_PERMANENT_TAG);
            return pumpingLemmaEnvironment;
        }
        if (serializable instanceof MooreMachine) {
            Automaton automaton = (Automaton)serializable;
            AutomatonEnvironment automatonEnvironment = new AutomatonEnvironment(automaton);
            EditorPane editorPane = new EditorPane(automaton, (ToolBox)new MooreToolBox());
            automatonEnvironment.add((Component)editorPane, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return automatonEnvironment;
        }
        if (serializable instanceof MealyMachine) {
            Automaton automaton = (Automaton)serializable;
            AutomatonEnvironment automatonEnvironment = new AutomatonEnvironment(automaton);
            EditorPane editorPane = new EditorPane(automaton, (ToolBox)new MealyToolBox());
            automatonEnvironment.add((Component)editorPane, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return automatonEnvironment;
        }
        if (serializable instanceof Automaton) {
            Automaton automaton = (Automaton)serializable;
            AutomatonEnvironment automatonEnvironment = new AutomatonEnvironment(automaton);
            EditorPane editorPane = new EditorPane(automaton);
            automatonEnvironment.add((Component)editorPane, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return automatonEnvironment;
        }
        if (serializable instanceof Grammar) {
            if (serializable instanceof ConvertedUnrestrictedGrammar) {
                ConvertedUnrestrictedGrammar convertedUnrestrictedGrammar = (ConvertedUnrestrictedGrammar)serializable;
                GrammarInputPane grammarInputPane = new GrammarInputPane(convertedUnrestrictedGrammar);
                GrammarEnvironment grammarEnvironment = new GrammarEnvironment(grammarInputPane);
                grammarEnvironment.add((Component)grammarInputPane, EDITOR_NAME, EDITOR_PERMANENT_TAG);
                return grammarEnvironment;
            }
            Grammar grammar = (Grammar)serializable;
            GrammarInputPane grammarInputPane = new GrammarInputPane(grammar);
            GrammarEnvironment grammarEnvironment = new GrammarEnvironment(grammarInputPane);
            grammarEnvironment.add((Component)grammarInputPane, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return grammarEnvironment;
        }
        if (serializable instanceof RegularExpression) {
            RegularExpression regularExpression = (RegularExpression)serializable;
            gui.regular.EditorPane editorPane = new gui.regular.EditorPane(regularExpression);
            RegularEnvironment regularEnvironment = new RegularEnvironment(regularExpression);
            regularEnvironment.add((Component)editorPane, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return regularEnvironment;
        }
        if (serializable instanceof LSystem) {
            LSystem lSystem = (LSystem)serializable;
            LSystemInputPane lSystemInputPane = new LSystemInputPane(lSystem);
            LSystemEnvironment lSystemEnvironment = new LSystemEnvironment(lSystemInputPane);
            lSystemEnvironment.add((Component)lSystemInputPane, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return lSystemEnvironment;
        }
        JOptionPane.showMessageDialog(null, "Unknown type " + serializable.getClass() + " read!", "Bad Type", 0);
        return null;
    }

    public static class EditorPermanentTag
    implements EditorTag,
    PermanentTag {
    }
}

