/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.fsa.FiniteStateAutomaton;
import automata.mealy.MealyMachine;
import automata.mealy.MooreMachine;
import automata.pda.PushdownAutomaton;
import automata.turing.TuringMachine;
import automata.vdg.VariableDependencyGraph;
import gui.editor.FSATransitionCreator;
import gui.editor.MealyTransitionCreator;
import gui.editor.MooreTransitionCreator;
import gui.editor.PDATransitionCreator;
import gui.editor.TMTransitionCreator;
import gui.editor.VDGTransitionCreator;
import gui.viewer.AutomatonPane;
import java.awt.Point;
import javax.swing.JOptionPane;

public abstract class TransitionCreator {
    private AutomatonPane parent = null;

    public TransitionCreator() {
    }

    public TransitionCreator(AutomatonPane automatonPane) {
        this.parent = automatonPane;
    }

    protected Automaton getAutomaton() {
        return this.getParent().getDrawer().getAutomaton();
    }

    public abstract Transition createTransition(State var1, State var2);

    public abstract boolean editTransition(Transition var1);

    public static TransitionCreator creatorForAutomaton(Automaton automaton, AutomatonPane automatonPane) {
        if (automaton instanceof FiniteStateAutomaton) {
            return new FSATransitionCreator(automatonPane);
        }
        if (automaton instanceof PushdownAutomaton) {
            return new PDATransitionCreator(automatonPane);
        }
        if (automaton instanceof TuringMachine) {
            return new TMTransitionCreator(automatonPane);
        }
        if (automaton instanceof VariableDependencyGraph) {
            return new VDGTransitionCreator(automatonPane);
        }
        if (automaton instanceof MooreMachine) {
            return new MooreTransitionCreator(automatonPane);
        }
        if (automaton instanceof MealyMachine) {
            return new MealyTransitionCreator(automatonPane);
        }
        return null;
    }

    public void editTransition(Transition transition, Point point) {
        this.editTransition(transition);
    }

    public AutomatonPane getParent() {
        return this.parent;
    }

    public void reportException(IllegalArgumentException illegalArgumentException) {
        JOptionPane.showMessageDialog(this.getParent(), "Bad format!\n" + illegalArgumentException.getMessage(), "Bad Format", 0);
    }
}

