/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.turing.TMTransition;
import gui.LambdaCellRenderer;
import gui.editor.TMTransitionCreator;
import gui.editor.TransitionCreator;
import gui.viewer.AutomatonPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public abstract class TableTransitionCreator
extends TransitionCreator {
    protected JTable editingTable = null;
    private Dimension tableDimensions;
    private Point tablePoint = new Point();
    private MouseListener viewListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TableTransitionCreator.this.stopEditing(false);
        }
    };
    private boolean isNew;
    private Transition transition;

    public TableTransitionCreator(AutomatonPane automatonPane) {
        super(automatonPane);
        automatonPane.addMouseListener(this.viewListener);
    }

    protected abstract Transition initTransition(State var1, State var2);

    protected abstract TableModel createModel(Transition var1);

    protected JTable createTable(final Transition transition) {
        TableModel tableModel = this.createModel(transition);
        final TipLambdaCellRenderer[] tipLambdaCellRendererArray = new TipLambdaCellRenderer[tableModel.getColumnCount()];
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            tipLambdaCellRendererArray[i] = transition instanceof TMTransition ? new TipLambdaCellRenderer("\u25a1", tableModel.getColumnName(i)) : new TipLambdaCellRenderer(tableModel.getColumnName(i));
        }
        JTable jTable = new JTable(this.createModel(transition)){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return tipLambdaCellRendererArray[n2];
            }

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (keyStroke.getKeyCode() == 10 && !keyStroke.isOnKeyRelease()) {
                    TableTransitionCreator.this.stopEditing(false);
                    if (keyEvent.isShiftDown()) {
                        TableTransitionCreator.this.createTransition(transition.getFromState(), transition.getToState());
                    }
                    return true;
                }
                if (keyStroke.getKeyCode() == 27) {
                    TableTransitionCreator.this.stopEditing(true);
                    return true;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
        };
        jTable.setGridColor(Color.gray);
        jTable.setBorder(new EtchedBorder());
        return jTable;
    }

    protected abstract Transition modifyTransition(Transition var1, TableModel var2);

    private void stopEditing(boolean bl) {
        Object object;
        if (this.editingTable == null) {
            return;
        }
        try {
            this.editingTable.getCellEditor().stopCellEditing();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Odd 'focusCycleRoot' exception thrown from the depths of Java again.");
        }
        if (!bl) {
            object = this.createModel(this.transition);
            Transition transition = this.modifyTransition(this.transition, this.editingTable.getModel());
            if (transition != null) {
                if (this.isNew) {
                    this.getParent().getDrawer().getAutomaton().addTransition(transition);
                } else {
                    this.getParent().getDrawer().getAutomaton().replaceTransition(this.transition, transition);
                }
            }
        }
        if (this instanceof TMTransitionCreator) {
            object = (TMTransitionCreator)this;
            ((TMTransitionCreator)object).setBlockTransition(false);
        }
        this.getParent().remove(this.editingTable);
        this.getParent().validate();
        this.getParent().repaint();
        this.editingTable = null;
        this.getParent().requestFocus();
    }

    @Override
    public boolean editTransition(Transition transition) {
        return false;
    }

    @Override
    public Transition createTransition(State state, State state2) {
        Transition transition = this.initTransition(state, state2);
        this.editTransition(transition, null);
        return null;
    }

    @Override
    public void editTransition(Transition transition, Point point) {
        this.stopEditing(false);
        this.transition = transition;
        boolean bl = this.isNew = point == null;
        if (this.isNew) {
            State state = transition.getFromState();
            State state2 = transition.getToState();
            point = new Point((state.getPoint().x + state2.getPoint().x) / 2, (state.getPoint().y + state2.getPoint().y) / 2);
        }
        this.getParent().setTablePoint(this.tablePoint);
        this.editingTable = this.createTable(transition);
        this.getParent().add(this.editingTable);
        this.getParent().validate();
        this.tableDimensions = this.editingTable.getSize();
        this.tablePoint = this.getParent().transformFromAutomatonToView(point);
        this.tablePoint.translate(-this.tableDimensions.width / 2, -this.tableDimensions.height / 2);
        this.getParent().setTablePoint(this.tablePoint);
        this.editingTable.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                componentEvent.getComponent().setLocation(TableTransitionCreator.this.tablePoint);
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                componentEvent.getComponent().setSize(TableTransitionCreator.this.tableDimensions);
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.editingTable.setLocation(this.tablePoint);
        this.editingTable.setSize(this.tableDimensions);
        this.editingTable.setCellSelectionEnabled(true);
        this.editingTable.changeSelection(0, 0, false, false);
        this.editingTable.requestFocus();
        this.getParent().repaint();
    }

    protected void editTransition(Transition transition, Point point, int n) {
    }

    private static class TipLambdaCellRenderer
    extends LambdaCellRenderer {
        public TipLambdaCellRenderer(String string, String string2) {
            super(string);
            this.setToolTipText(string2);
        }

        public TipLambdaCellRenderer(String string) {
            this.setToolTipText(string);
        }
    }
}

