/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.mealy.MealyTransition;
import gui.editor.TableTransitionCreator;
import gui.viewer.AutomatonPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class MealyTransitionCreator
extends TableTransitionCreator {
    private static final String[] NAME = new String[]{"Label", "Output"};

    public MealyTransitionCreator(AutomatonPane automatonPane) {
        super(automatonPane);
    }

    @Override
    protected Transition initTransition(State state, State state2) {
        return new MealyTransition(state, state2, "", "");
    }

    @Override
    protected TableModel createModel(Transition transition) {
        final MealyTransition mealyTransition = (MealyTransition)transition;
        return new AbstractTableModel(){
            String[] s;
            {
                this.s = new String[]{mealyTransition.getLabel(), mealyTransition.getOutput()};
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return this.s[n2];
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                this.s[n2] = (String)object;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            @Override
            public int getRowCount() {
                return 1;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int n) {
                return NAME[n];
            }
        };
    }

    @Override
    public Transition modifyTransition(Transition transition, TableModel tableModel) {
        String string = (String)tableModel.getValueAt(0, 0);
        String string2 = (String)tableModel.getValueAt(0, 1);
        MealyTransition mealyTransition = (MealyTransition)transition;
        try {
            return new MealyTransition(mealyTransition.getFromState(), mealyTransition.getToState(), string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportException(illegalArgumentException);
            return null;
        }
    }
}

