/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.fsa.FiniteStateAutomaton;
import gui.SplitPaneFactory;
import gui.TooltipAction;
import gui.deterministic.ConversionController;
import gui.deterministic.StateExpanderTool;
import gui.deterministic.TransitionExpanderTool;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.environment.Environment;
import gui.viewer.AutomatonDraggerPane;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class ConversionPane
extends JPanel {
    private ConversionController controller;
    EditorPane editor;

    public ConversionPane(FiniteStateAutomaton finiteStateAutomaton, Environment environment) {
        super(new BorderLayout());
        FiniteStateAutomaton finiteStateAutomaton2 = new FiniteStateAutomaton();
        this.controller = new ConversionController(finiteStateAutomaton, finiteStateAutomaton2, this);
        AutomatonDraggerPane automatonDraggerPane = new AutomatonDraggerPane(finiteStateAutomaton);
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(environment, true, 0.25, automatonDraggerPane, this.createEditor(finiteStateAutomaton2));
        this.add((Component)jSplitPane, "Center");
        this.addComponentListener(new ComponentAdapter(){
            boolean doneBefore = false;

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                ConversionPane.this.controller.performFirstLayout();
                ConversionPane.this.editor.getAutomatonPane().repaint();
            }
        });
    }

    private EditorPane createEditor(FiniteStateAutomaton finiteStateAutomaton) {
        SelectionDrawer selectionDrawer = new SelectionDrawer(finiteStateAutomaton);
        this.editor = new EditorPane(selectionDrawer, new ToolBox(){

            @Override
            public List tools(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
                LinkedList<Tool> linkedList = new LinkedList<Tool>();
                linkedList.add(new ArrowNontransitionTool(automatonPane, automatonDrawer));
                linkedList.add(new TransitionExpanderTool(automatonPane, automatonDrawer, ConversionPane.this.controller));
                linkedList.add(new StateExpanderTool(automatonPane, automatonDrawer, ConversionPane.this.controller));
                return linkedList;
            }
        });
        this.addExtras(this.editor.getToolBar());
        return this.editor;
    }

    private void addExtras(JToolBar jToolBar) {
        jToolBar.addSeparator();
        jToolBar.add(new TooltipAction("Complete", "This will finish all expansion."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConversionPane.this.controller.complete();
            }
        });
        jToolBar.add(new TooltipAction("Done?", "Are we finished?"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConversionPane.this.controller.done();
            }
        });
    }
}

