/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.turing.TuringMachine;
import file.Codec;
import file.DataException;
import file.ParseException;
import gui.action.RestrictedAction;
import gui.environment.EnvironmentFrame;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class OpenAction
extends RestrictedAction {
    private static boolean openOrRead = false;
    private JFileChooser fileChooser;
    private static Serializable lastObject = null;
    private static File lastFile = null;
    private static boolean lastFileOpened = false;

    public OpenAction() {
        super("Open...", null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, MAIN_MENU_MASK));
        this.fileChooser = Universe.CHOOSER;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Component component = null;
        lastFileOpened = false;
        try {
            component = (Component)actionEvent.getSource();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File file = this.fileChooser.getCurrentDirectory();
        this.fileChooser.setCurrentDirectory(file.getParentFile());
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setMultiSelectionEnabled(true);
        Codec[] codecArray = null;
        codecArray = OpenAction.makeFilters();
        int n = this.fileChooser.showOpenDialog(component);
        if (n != 0) {
            return;
        }
        File[] fileArray = this.fileChooser.getSelectedFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!openOrRead && Universe.frameForFile(file2) != null) {
                Universe.frameForFile(file2).toFront();
                return;
            }
            try {
                OpenAction.openFile(file2, codecArray);
                continue;
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(component, parseException.getMessage(), "Read Error", 0);
                continue;
            }
            catch (DataException dataException) {
                JOptionPane.showMessageDialog(component, dataException.getMessage(), "Data Error", 0);
            }
        }
        Universe.CHOOSER.resetChoosableFileFilters();
        lastFileOpened = true;
    }

    public static Serializable readFileAndCodecs(File file) {
        OpenAction.setOpenOrRead(true);
        Codec[] codecArray = null;
        codecArray = OpenAction.makeFilters();
        OpenAction.openFile(file, codecArray);
        OpenAction.setOpenOrRead(false);
        return OpenAction.getLastObjectOpened();
    }

    public static Codec[] makeFilters() {
        Universe.CHOOSER.resetChoosableFileFilters();
        List list = Universe.CODEC_REGISTRY.getDecoders();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Universe.CHOOSER.addChoosableFileFilter((FileFilter)iterator.next());
        }
        Universe.CHOOSER.setFileFilter(Universe.CHOOSER.getAcceptAllFileFilter());
        Codec[] codecArray = null;
        FileFilter fileFilter = Universe.CHOOSER.getFileFilter();
        codecArray = fileFilter == Universe.CHOOSER.getAcceptAllFileFilter() ? list.toArray(new Codec[0]) : new Codec[]{(Codec)fileFilter};
        return codecArray;
    }

    public static void openFile(File file, Codec[] codecArray) {
        ParseException parseException = null;
        for (int i = 0; i < codecArray.length; ++i) {
            try {
                Serializable serializable = codecArray[i].decode(file, null);
                if (openOrRead && !(serializable instanceof TuringMachine)) {
                    JOptionPane.showMessageDialog(null, "Only Turing Machine files can be added as building blocks.", "Wrong File Type", 0);
                    return;
                }
                lastObject = serializable;
                lastFile = file;
                if (!openOrRead) {
                    EnvironmentFrame environmentFrame = FrameFactory.createFrame(serializable);
                    if (environmentFrame == null) {
                        return;
                    }
                    environmentFrame.getEnvironment().setFile(file);
                    environmentFrame.getEnvironment().setEncoder(codecArray[i].correspondingEncoder());
                }
                return;
            }
            catch (ParseException parseException2) {
                parseException = parseException2;
                continue;
            }
        }
        if (codecArray.length != 1) {
            parseException = new ParseException("No format could read the file!");
        }
        throw parseException;
    }

    public static boolean isApplicable(Object object) {
        return true;
    }

    public static Serializable getLastObjectOpened() {
        return lastObject;
    }

    public static File getLastFileOpened() {
        return lastFile;
    }

    public static boolean isOpened() {
        return lastFileOpened;
    }

    public static void setOpenOrRead(boolean bl) {
        openOrRead = bl;
    }

    protected static class FileReadException
    extends RuntimeException {
        public FileReadException(String string) {
            super(string);
        }
    }
}

