/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.action.ConvertAutomatonToGrammarAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.FSAConvertController;
import gui.viewer.SelectionDrawer;
import gui.viewer.ZoomPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class ConvertFSAToGrammarAction
extends ConvertAutomatonToGrammarAction {
    public ConvertFSAToGrammarAction(AutomatonEnvironment automatonEnvironment) {
        super(automatonEnvironment);
    }

    @Override
    protected boolean checkAutomaton() {
        if (this.getAutomaton().getStates().length > 26) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.getEnvironment()), "There may be at most 26 states for conversion.", "Number of States Error", 0);
            return false;
        }
        HashSet<Transition> hashSet = new HashSet<Transition>();
        Transition[] transitionArray = this.getAutomaton().getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            if (!((FSATransition)transitionArray[i]).getLabel().matches(".*[A-Z].*")) continue;
            hashSet.add(transitionArray[i]);
        }
        if (hashSet.size() != 0) {
            EnvironmentFrame environmentFrame = Universe.frameForEnvironment(this.getEnvironment());
            JPanel jPanel = new JPanel(new BorderLayout());
            SelectionDrawer selectionDrawer = new SelectionDrawer(this.getAutomaton());
            JLabel jLabel = new JLabel();
            ZoomPane zoomPane = new ZoomPane(selectionDrawer);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(new BevelBorder(1));
            zoomPane.setPreferredSize(new Dimension(300, 200));
            jPanel2.add((Component)zoomPane, "Center");
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)jLabel, "South");
            selectionDrawer.clearSelected();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                selectionDrawer.addSelected((Transition)iterator.next());
            }
            jLabel.setText("Capital letters are reserved for grammar variables.");
            JOptionPane.showMessageDialog(environmentFrame, jPanel, "Transitions With Capitals Error", 0);
            return false;
        }
        return true;
    }

    @Override
    protected ConvertController initializeController(ConvertPane convertPane, SelectionDrawer selectionDrawer, Automaton automaton) {
        return new FSAConvertController(convertPane, selectionDrawer, (FiniteStateAutomaton)automaton);
    }

    public static boolean isApplicable(Object object) {
        return object instanceof FiniteStateAutomaton;
    }
}

