/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.State;
import gui.action.RestrictedAction;
import gui.editor.EditBlockPane;
import gui.environment.Environment;
import gui.environment.tag.PermanentTag;
import gui.environment.tag.Tag;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CloseAction
extends RestrictedAction {
    private Environment environment;

    public CloseAction(Environment environment) {
        super("Dismiss Tab", null);
        this.environment = environment;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, MAIN_MENU_MASK));
        environment.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CloseAction.this.checkEnabled();
            }
        });
        this.checkEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        Automaton automaton = null;
        State state = null;
        if (this.environment.getActive() instanceof EditBlockPane) {
            bl = true;
            EditBlockPane editBlockPane = (EditBlockPane)this.environment.getActive();
            automaton = editBlockPane.getAutomaton();
            state = editBlockPane.getBlock();
        }
        this.environment.remove(this.environment.getActive());
    }

    private void checkEnabled() {
        Tag tag = this.environment.getTag(this.environment.getActive());
        if (this.environment.tabbed.getTabCount() == 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!(tag instanceof PermanentTag));
        }
    }
}

