/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.LambdaProductionRemover;
import grammar.Production;
import grammar.UnitProductionRemover;
import grammar.UnrestrictedGrammar;
import grammar.UselessProductionRemover;
import gui.action.GrammarAction;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.parse.CYKParsePane;
import gui.grammar.transform.LambdaController;
import gui.grammar.transform.LambdaPane;
import gui.grammar.transform.UnitController;
import gui.grammar.transform.UnitPane;
import gui.grammar.transform.UselessController;
import gui.grammar.transform.UselessPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;

public class CYKParseAction
extends GrammarAction {
    protected GrammarEnvironment environment;
    protected EnvironmentFrame frame;
    protected Grammar myGrammar;
    protected boolean myErrorInTransform;
    private ArrayList<Production> myTempCNF;

    public CYKParseAction(GrammarEnvironment grammarEnvironment) {
        super("CYK Parse", null);
        this.environment = grammarEnvironment;
        this.frame = Universe.frameForEnvironment(grammarEnvironment);
    }

    public CYKParseAction(String string, GrammarEnvironment grammarEnvironment) {
        super(string, null);
        this.environment = grammarEnvironment;
        this.frame = Universe.frameForEnvironment(grammarEnvironment);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Grammar grammar;
        this.myGrammar = grammar = this.environment.getGrammar(UnrestrictedGrammar.class);
        if (grammar == null) {
            return;
        }
        if (grammar.getTerminals().length == 0) {
            JOptionPane.showMessageDialog(this.environment, "Error : This grammar does not accept any Strings. ", "Cannot Proceed with CYK", 0);
            this.myErrorInTransform = true;
            return;
        }
        this.hypothesizeLambda(this.environment, grammar);
        if (!this.myErrorInTransform) {
            CYKParsePane cYKParsePane = new CYKParsePane(this.environment, grammar, this.myGrammar);
            this.environment.add((Component)cYKParsePane, "CYK Parse", new CriticalTag(){});
            this.environment.setActive(cYKParsePane);
        }
    }

    protected void hypothesizeLambda(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        LambdaProductionRemover lambdaProductionRemover = new LambdaProductionRemover();
        HashSet hashSet = lambdaProductionRemover.getCompleteLambdaSet(grammar);
        if (hashSet.contains(grammar.getStartVariable())) {
            JOptionPane.showMessageDialog(grammarEnvironment, "WARNING : The start variable derives lambda.\nNew Grammar will not produce lambda String.", "Start Derives Lambda", 0);
        }
        if (hashSet.size() > 0) {
            LambdaPane lambdaPane = new LambdaPane(grammarEnvironment, grammar);
            LambdaController lambdaController = new LambdaController(lambdaPane, grammar);
            lambdaController.doAll();
            grammar = lambdaController.getGrammar();
        }
        this.hypothesizeUnit(grammarEnvironment, grammar);
    }

    protected void hypothesizeUnit(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        UnitProductionRemover unitProductionRemover = new UnitProductionRemover();
        if (unitProductionRemover.getUnitProductions(grammar).length > 0) {
            UnitPane unitPane = new UnitPane(grammarEnvironment, grammar);
            UnitController unitController = new UnitController(unitPane, grammar);
            unitController.doAll();
            grammar = unitController.getGrammar();
        }
        this.hypothesizeUseless(grammarEnvironment, grammar);
    }

    protected void hypothesizeUseless(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        Production[] productionArray;
        UselessProductionRemover uselessProductionRemover = new UselessProductionRemover();
        Grammar grammar2 = UselessProductionRemover.getUselessProductionlessGrammar(grammar);
        if (grammar2.getTerminals().length == 0) {
            JOptionPane.showMessageDialog(grammarEnvironment, "Error : This grammar does not accept any Strings. ", "Cannot Proceed with CYK", 0);
            this.myErrorInTransform = true;
            return;
        }
        Production[] productionArray2 = grammar.getProductions();
        if (productionArray2.length > (productionArray = grammar2.getProductions()).length) {
            UselessPane uselessPane = new UselessPane(grammarEnvironment, grammar);
            UselessController uselessController = new UselessController(uselessPane, grammar);
            uselessController.doAll();
            grammar = uselessController.getGrammar();
        }
        this.hypothesizeChomsky(grammarEnvironment, grammar);
    }

    protected void hypothesizeChomsky(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        CNFConverter cNFConverter = null;
        try {
            cNFConverter = new CNFConverter(grammar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(grammarEnvironment, illegalArgumentException.getMessage(), "Illegal Grammar", 0);
            return;
        }
        Production[] productionArray = grammar.getProductions();
        boolean bl = true;
        for (int i = 0; i < productionArray.length; ++i) {
            bl &= cNFConverter.isChomsky(productionArray[i]);
        }
        if (!bl) {
            ArrayList<Production> arrayList = new ArrayList<Production>();
            for (int i = 0; i < productionArray.length; ++i) {
                this.myTempCNF = new ArrayList();
                cNFConverter = new CNFConverter(grammar);
                this.convertToCNF(cNFConverter, productionArray[i]);
                arrayList.addAll(this.myTempCNF);
            }
            Production[] productionArray2 = new Production[arrayList.size()];
            for (int i = 0; i < productionArray2.length; ++i) {
                productionArray2[i] = (Production)arrayList.get(i);
            }
            productionArray2 = CNFConverter.convert(productionArray2);
            String string = grammar.getStartVariable();
            grammar = new UnrestrictedGrammar();
            grammar.addProductions(productionArray2);
            grammar.setStartVariable(string);
        }
        this.myGrammar = grammar;
    }

    private void convertToCNF(CNFConverter cNFConverter, Production production) {
        if (!cNFConverter.isChomsky(production)) {
            Production[] productionArray = cNFConverter.replacements(production);
            for (int i = 0; i < productionArray.length; ++i) {
                production = productionArray[i];
                this.convertToCNF(cNFConverter, production);
            }
        } else {
            this.myTempCNF.add(production);
        }
    }
}

