/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonChecker;
import automata.State;
import automata.Transition;
import gui.action.FSAAction;
import gui.deterministic.AddTrapStatePane;
import gui.environment.AutomatonEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class AddTrapStateToDFAAction
extends FSAAction {
    private Automaton automaton;
    private AutomatonEnvironment environment;

    public AddTrapStateToDFAAction(AutomatonEnvironment automatonEnvironment) {
        super("Add Trap State to DFA", null);
        this.environment = automatonEnvironment;
        this.automaton = automatonEnvironment.getAutomaton();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "The automaton should have an initial state.");
            return;
        }
        AutomatonChecker automatonChecker = new AutomatonChecker();
        if (automatonChecker.isNFA(this.automaton)) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "This isn't a DFA!");
            return;
        }
        boolean bl = this.checkIfDFAisComplete();
        if (bl) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "DFA is complete. No need for the Trap State");
            return;
        }
        AddTrapStatePane addTrapStatePane = new AddTrapStatePane(this.environment);
        this.environment.add((Component)addTrapStatePane, "Adding Trap State", new CriticalTag(){});
        this.environment.setActive(addTrapStatePane);
    }

    private boolean checkIfDFAisComplete() {
        int n;
        Transition[] transitionArray = this.automaton.getTransitions();
        State[] stateArray = this.automaton.getStates();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (n = 0; n < transitionArray.length; ++n) {
            treeSet.add(transitionArray[n].getDescription());
        }
        n = 0;
        for (int i = 0; i < stateArray.length; ++i) {
            Transition[] transitionArray2 = this.automaton.getTransitionsFromState(stateArray[i]);
            if (transitionArray2.length >= treeSet.size()) continue;
            ++n;
        }
        return n == 0;
    }
}

