/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class ImageDisplayComponent
extends JComponent
implements Scrollable {
    private Image myImage;
    private Point myOrigin;
    private static final Point ZERO_ORIGIN = new Point(0, 0);

    public ImageDisplayComponent() {
        this((Image)null);
    }

    public ImageDisplayComponent(Image image) {
        this.setImage(image);
    }

    public ImageDisplayComponent(URL uRL) {
        this.setImage(this.getBaseImage(uRL));
    }

    public ImageDisplayComponent(String string) {
        this.setImage(this.getBaseImage(string));
    }

    public Image getImage() {
        return this.myImage;
    }

    public void setImage(Image image, Point point) {
        this.myImage = image;
        this.myOrigin = point;
        this.trackImage(this.getImage());
        this.redefineSize();
    }

    public void setImage(Image image) {
        this.setImage(image, ZERO_ORIGIN);
    }

    private Image getBaseImage(String string) {
        return Toolkit.getDefaultToolkit().getImage(string);
    }

    private Image getBaseImage(URL uRL) {
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    private boolean trackImage(Image image) {
        if (image == null) {
            return true;
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private void redefineSize() {
        Dimension dimension = new Dimension(1, 1);
        if (this.myImage != null) {
            dimension = new Dimension(this.getImage().getWidth(this), this.getImage().getHeight(this));
        }
        this.setPreferredSize(dimension);
        this.setBounds(-this.myOrigin.x, -this.myOrigin.y, dimension.width, dimension.height);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.myImage == null) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(this.getPreferredSize());
        int n = rectangle.width > rectangle2.width ? (rectangle.width - rectangle2.width) / 2 : 0;
        int n2 = rectangle.height > rectangle2.height ? (rectangle.height - rectangle2.height) / 2 : 0;
        rectangle = rectangle.intersection(rectangle2);
        graphics.drawImage(this.myImage, rectangle.x + n, rectangle.y + n2, rectangle.x + rectangle.width + n, rectangle.y + rectangle.height + n2, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, this);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 5;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getPreferredSize().width < this.getParent().getSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getSize().height;
    }
}

