/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.UnrestrictedGrammar;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Unrestricted {
    private Unrestricted() {
    }

    public static int minimumLength(String string, Set set) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (set.contains(string.substring(i, i + 1))) continue;
            ++n;
        }
        return n;
    }

    private static int count(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static Set smallerSymbols(Grammar grammar) {
        boolean bl;
        HashSet<String> hashSet = new HashSet<String>();
        Production[] productionArray = grammar.getProductions();
        do {
            bl = false;
            for (int i = 0; i < productionArray.length; ++i) {
                String string = productionArray[i].getLHS();
                String string2 = productionArray[i].getRHS();
                int n = Unrestricted.minimumLength(string2, hashSet);
                int n2 = Unrestricted.minimumLength(string, hashSet);
                if (n2 <= n) continue;
                for (int j = 0; j < string.length(); ++j) {
                    String string3 = string.substring(j, j + 1);
                    char c = string3.charAt(0);
                    if (hashSet.contains(string3) || Unrestricted.count(string, c) <= Unrestricted.count(string2, c)) continue;
                    hashSet.add(string3);
                    bl = true;
                }
            }
        } while (bl);
        return hashSet;
    }

    public static boolean isUnrestricted(Grammar grammar) {
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (productionArray[i].getLHS().length() == 1) continue;
            return true;
        }
        return false;
    }

    public static UnrestrictedGrammar optimize(Grammar grammar) {
        int n;
        int n2;
        String string = grammar.getStartVariable();
        Production[] productionArray = grammar.getProductions();
        HashSet<String> hashSet = new HashSet<String>();
        boolean[] blArray = new boolean[productionArray.length];
        for (n2 = 0; n2 < productionArray.length; ++n2) {
            blArray[n2] = false;
            if (productionArray[n2].getVariablesOnRHS().length != 0) continue;
            hashSet.addAll(Arrays.asList(productionArray[n2].getSymbols()));
            blArray[n2] = true;
        }
        do {
            n2 = 0;
            for (int i = 0; i < productionArray.length; ++i) {
                List<String> list = Arrays.asList(productionArray[i].getVariablesOnRHS());
                if (blArray[i] || !hashSet.containsAll(list)) continue;
                hashSet.addAll(Arrays.asList(productionArray[i].getSymbols()));
                n2 = 1;
                blArray[i] = 1;
            }
        } while (n2 != 0);
        UnrestrictedGrammar unrestrictedGrammar = new UnrestrictedGrammar();
        unrestrictedGrammar.setStartVariable(grammar.getStartVariable());
        for (n = 0; !(n >= productionArray.length || blArray[n] && productionArray[n].getLHS().equals(string)); ++n) {
        }
        if (n == productionArray.length) {
            return null;
        }
        unrestrictedGrammar.addProduction(productionArray[n]);
        blArray[n] = false;
        for (n = 0; n < productionArray.length; ++n) {
            if (!blArray[n]) continue;
            unrestrictedGrammar.addProduction(productionArray[n]);
        }
        return unrestrictedGrammar;
    }
}

