/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import grammar.Grammar;
import grammar.Production;
import grammar.parse.LRParseTable;
import java.util.Map;
import java.util.Set;

public abstract class LRParseTableGenerator {
    public static LRParseTable generate(Grammar grammar, FiniteStateAutomaton finiteStateAutomaton, Map map, Map map2, Map map3) {
        LRParseTable lRParseTable = new LRParseTable(grammar, finiteStateAutomaton){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        Transition[] transitionArray = finiteStateAutomaton.getTransitions();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < transitionArray.length; ++i) {
            FSATransition fSATransition = (FSATransition)transitionArray[i];
            if (grammar.isVariable(fSATransition.getLabel())) {
                lRParseTable.appendValueAt("" + fSATransition.getToState().getID(), fSATransition.getFromState().getID(), fSATransition.getLabel());
                continue;
            }
            lRParseTable.appendValueAt("s" + fSATransition.getToState().getID(), fSATransition.getFromState().getID(), fSATransition.getLabel());
        }
        State[] stateArray = finiteStateAutomaton.getFinalStates();
        for (int i = 0; i < stateArray.length; ++i) {
            Set set = (Set)map.get(stateArray[i]);
            for (Production production : set) {
                if (production.getLHS().length() == 2) {
                    if (production.getRHS().length() != 2 || production.getRHS().charAt(1) != '\u00b7') continue;
                    lRParseTable.appendValueAt("acc", stateArray[i].getID(), "$");
                    continue;
                }
                if (!production.getRHS().endsWith("\u00b7")) continue;
                Production production2 = new Production(production.getLHS(), production.getRHS().substring(0, production.getRHS().length() - 1));
                int n = 0;
                while (!production2.equals(productionArray[n])) {
                    ++n;
                }
                Set set2 = (Set)map3.get(production.getLHS());
                for (String string : set2) {
                    lRParseTable.appendValueAt("r" + n, stateArray[i].getID(), string);
                }
            }
        }
        return lRParseTable;
    }
}

