/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.Codec;
import file.EncodeException;
import file.ParseException;
import file.xml.DOMPrettier;
import file.xml.Transducer;
import file.xml.TransducerFactory;
import gui.pumping.PumpingLemmaChooser;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLCodec
extends Codec {
    public static final String SUFFIX = ".jff";

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().endsWith(".xml") || file.getName().endsWith(SUFFIX);
    }

    @Override
    public Serializable decode(File file, Map map) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Transducer transducer = TransducerFactory.getTransducer(document);
            return transducer.fromDOM(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParseException("Java could not create the parser!");
        }
        catch (IOException iOException) {
            throw new ParseException("Could not open file to read!");
        }
        catch (SAXException sAXException) {
            throw new ParseException("Could not parse XML!\n" + sAXException.getMessage());
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            System.err.println("STATIC INIT:");
            exceptionInInitializerError.getException().printStackTrace();
            throw new ParseException("Unexpected Error!");
        }
    }

    @Override
    public File encode(Serializable serializable, File file, Map map) {
        Transducer transducer = null;
        try {
            transducer = TransducerFactory.getTransducer(serializable);
            Document document = serializable instanceof PumpingLemmaChooser ? transducer.toDOM(((PumpingLemmaChooser)serializable).getCurrent()) : transducer.toDOM(serializable);
            DOMPrettier.makePretty(document);
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(dOMSource, streamResult);
            return file;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EncodeException("No XML transducer available for this structure!");
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new EncodeException("Could not open file to write!");
        }
        catch (TransformerException transformerException) {
            throw new EncodeException("Could not open file to write!");
        }
    }

    @Override
    public boolean canEncode(Serializable serializable) {
        return true;
    }

    @Override
    public String getDescription() {
        return "JFLAP 4 File";
    }

    @Override
    public String proposeFilename(String string, Serializable serializable) {
        if (!string.endsWith(SUFFIX)) {
            return string + SUFFIX;
        }
        return string;
    }
}

