/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.State;
import automata.Transition;
import automata.turing.TMTransition;
import grammar.Production;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TuringToGrammarConverter {
    private static final String SQUARE_SYMBOL = "\u25a1";
    private static final String SQUARE = "=";
    private static final String VAR_START = "V(";
    private static final String VAR_END = ")";
    private HashSet<String> myAllReadableString = new HashSet();
    private HashSet<String> myAllWritableString = new HashSet();

    public Production[] createProductionsForInit(State state, Transition[] transitionArray) {
        int n = state.getID();
        ArrayList<Production> arrayList = new ArrayList<Production>();
        arrayList.add(new Production("S", "V(==)S"));
        arrayList.add(new Production("S", "SV(==)"));
        arrayList.add(new Production("S", "T"));
        this.myAllReadableString.add(SQUARE);
        for (int i = 0; i < transitionArray.length; ++i) {
            TMTransition tMTransition = (TMTransition)transitionArray[i];
            int n2 = tMTransition.getTapeLength();
            for (int j = 0; j < n2; ++j) {
                String string;
                String string2 = tMTransition.getRead(j);
                if (string2.equals(SQUARE_SYMBOL)) {
                    string2 = SQUARE;
                }
                if ((string = tMTransition.getWrite(j)).equals(SQUARE_SYMBOL)) {
                    string = SQUARE;
                }
                this.myAllWritableString.add(string);
                if (this.myAllReadableString.contains(string2)) continue;
                this.myAllReadableString.add(string2);
                String string3 = VAR_START + string2 + string2 + VAR_END;
                String string4 = VAR_START + string2 + n + string2 + VAR_END;
                arrayList.add(new Production("T", "T" + string3));
                arrayList.add(new Production("T", string4));
            }
        }
        arrayList.add(new Production(SQUARE, null));
        Production[] productionArray = new Production[arrayList.size()];
        for (int i = 0; i < productionArray.length; ++i) {
            productionArray[i] = (Production)arrayList.get(i);
        }
        return productionArray;
    }

    public Production[] createProductionsForTransition(Transition transition, State[] stateArray) {
        int n;
        ArrayList<Production> arrayList = new ArrayList<Production>();
        TMTransition tMTransition = (TMTransition)transition;
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        for (n = 0; n < stateArray.length; ++n) {
            hashMap.put(stateArray[n].getID(), true);
        }
        n = tMTransition.getFromState().getID();
        int n2 = tMTransition.getToState().getID();
        int n3 = tMTransition.getTapeLength();
        for (int i = 0; i < n3; ++i) {
            String string = tMTransition.getDirection(i);
            String string2 = tMTransition.getRead(i);
            String string3 = tMTransition.getWrite(i);
            if (string2.equals(SQUARE_SYMBOL)) {
                string2 = SQUARE;
            }
            if (string3.equals(SQUARE_SYMBOL)) {
                string3 = SQUARE;
            }
            for (String string4 : this.myAllReadableString) {
                for (String string5 : this.myAllReadableString) {
                    for (String string6 : this.myAllWritableString) {
                        String string7;
                        String string8;
                        String string9;
                        String string10;
                        Production production;
                        String string11;
                        String string12;
                        String string13;
                        String string14;
                        if (string.equals("R")) {
                            string14 = VAR_START + string5 + n + string2 + VAR_END;
                            string13 = VAR_START + string4 + string6 + VAR_END;
                            string12 = VAR_START + string5 + string3 + VAR_END;
                            string11 = VAR_START + string4 + n2 + string6 + VAR_END;
                            production = new Production(string14 + string13, string12 + string11);
                            arrayList.add(production);
                            if (hashMap.containsKey(n2)) {
                                string10 = VAR_START + string4 + n2 + string6 + VAR_END;
                                string9 = string4;
                                arrayList.add(new Production(string10, string9));
                                string8 = VAR_START + string5 + string6 + VAR_END + string4;
                                arrayList.add(new Production(string8, string5 + string9));
                                string7 = string4 + VAR_START + string5 + string6 + VAR_END;
                                arrayList.add(new Production(string7, string4 + string5));
                            }
                        }
                        if (string.equals("L")) {
                            string14 = VAR_START + string4 + string6 + VAR_END;
                            string13 = VAR_START + string5 + n + string2 + VAR_END;
                            string12 = VAR_START + string4 + n2 + string6 + VAR_END;
                            string11 = VAR_START + string5 + string3 + VAR_END;
                            production = new Production(string14 + string13, string12 + string11);
                            arrayList.add(production);
                            if (hashMap.containsKey(n2)) {
                                string10 = VAR_START + string4 + n2 + string6 + VAR_END;
                                string9 = string4;
                                string8 = string4 + VAR_START + string5 + string6 + VAR_END;
                                arrayList.add(new Production(string10, string9));
                                arrayList.add(new Production(string8, string4 + string5));
                                string7 = VAR_START + string5 + string6 + VAR_END + string4;
                                arrayList.add(new Production(string7, string5 + string9));
                            }
                        }
                        if (!string.equals("S")) continue;
                    }
                }
            }
        }
        Production[] productionArray = new Production[arrayList.size()];
        for (int i = 0; i < productionArray.length; ++i) {
            productionArray[i] = (Production)arrayList.get(i);
        }
        return productionArray;
    }
}

