/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JOptionPane;

public class VertexMover
extends LayoutAlgorithm {
    public static final int HORIZONTAL_CENTER = -10;
    public static final int VERTICAL_CENTER = -11;
    public static final int POSITIVE_SLOPE_DIAGONAL = -12;
    public static final int NEGATIVE_SLOPE_DIAGONAL = -13;
    public static final int ROTATE = -14;
    public static final int FILL = -15;
    private int command;

    public VertexMover(int n) {
        this.command = n;
    }

    public VertexMover(Dimension dimension, Dimension dimension2, double d, int n) {
        super(dimension, dimension2, d);
        this.command = n;
    }

    @Override
    public void layout(Graph graph, Set set) {
        ArrayList arrayList = VertexMover.getMovableVertices(graph, set);
        if (this.command == -15) {
            VertexMover.shiftOntoScreen(graph, this.size, this.vertexDim, false);
            return;
        }
        if (this.command == -10) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = graph.pointForVertex(arrayList.get(i));
                graph.moveVertex(arrayList.get(i), new Point2D.Double(point2D.getX(), this.size.getHeight() - point2D.getY()));
            }
        } else if (this.command == -11) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = graph.pointForVertex(arrayList.get(i));
                graph.moveVertex(arrayList.get(i), new Point2D.Double(this.size.getWidth() - point2D.getX(), point2D.getY()));
            }
        } else if (this.command == -12) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = graph.pointForVertex(arrayList.get(i));
                graph.moveVertex(arrayList.get(i), new Point2D.Double(point2D.getY(), point2D.getX()));
            }
        } else if (this.command == -13) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = graph.pointForVertex(arrayList.get(i));
                graph.moveVertex(arrayList.get(i), new Point2D.Double(this.size.getWidth() - point2D.getY(), this.size.getHeight() - point2D.getX()));
            }
        } else if (this.command == -14) {
            double d = 0.0;
            try {
                String string = JOptionPane.showInputDialog("How many degrees to turn the automaton? \n(positive - clockwise, negative - counterclockwise)", (Object)new String("180"));
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "That is not a valid degree value.", "Invalid Input", 0);
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            VertexMover.cartesianToPolar(graph, arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = graph.pointForVertex(arrayList.get(i));
                graph.moveVertex(arrayList.get(i), new Point2D.Double(point2D.getX(), point2D.getY() + d / -180.0 * Math.PI));
            }
            VertexMover.polarToCartesian(graph, arrayList);
        }
        VertexMover.shiftOntoScreen(graph, this.size, this.vertexDim, true);
    }
}

