/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Set;

public class RandomLayoutAlgorithm
extends LayoutAlgorithm {
    private ArrayList vertices;
    private ArrayList points;
    private VertexChain chain;

    public RandomLayoutAlgorithm() {
    }

    public RandomLayoutAlgorithm(Dimension dimension, Dimension dimension2, double d) {
        super(dimension, dimension2, d);
    }

    @Override
    public void layout(Graph graph, Set set) {
        this.vertices = RandomLayoutAlgorithm.getMovableVertices(graph, set);
        if (graph == null || this.vertices.size() == 0) {
            return;
        }
        this.chain = new VertexChain(graph);
        this.assignPointsAndVertices();
        this.lessenVertexOverlap();
        this.findCorrectPointOrder();
        for (int i = 0; i < this.points.size(); ++i) {
            graph.moveVertex(this.chain.get(i), (Point2D)this.points.get(i));
        }
        RandomLayoutAlgorithm.shiftOntoScreen(graph, this.size, this.vertexDim, true);
    }

    private void assignPointsAndVertices() {
        Random random = new Random();
        this.points = new ArrayList();
        for (int i = 0; i < this.vertices.size(); ++i) {
            double d = random.nextDouble() * (this.size.getWidth() - this.vertexBuffer * 2.0);
            double d2 = random.nextDouble() * (this.size.getHeight() - this.vertexBuffer * 2.0);
            this.points.add(new Point2D.Double(d, d2));
            this.chain.addVertex(this.vertices.get(i));
        }
    }

    private void lessenVertexOverlap() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        arrayList.addAll(this.points);
        arrayList2.addAll(this.points);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                if (((Point2D)object).getX() == ((Point2D)object2).getX()) {
                    return 0;
                }
                if (((Point2D)object).getX() < ((Point2D)object2).getX()) {
                    return 1;
                }
                return -1;
            }
        });
        Collections.sort(arrayList2, new Comparator(){

            public int compare(Object object, Object object2) {
                if (((Point2D)object).getY() == ((Point2D)object2).getY()) {
                    return 0;
                }
                if (((Point2D)object).getY() < ((Point2D)object2).getY()) {
                    return 1;
                }
                return -1;
            }
        });
        double d = this.vertexDim.getWidth() + this.vertexBuffer;
        double d2 = this.vertexDim.getHeight() + this.vertexBuffer;
        for (int i = 0; i < this.vertices.size() - 1; ++i) {
            Point2D point2D;
            int n;
            double d3 = ((Point2D)arrayList.get(i)).getX() - ((Point2D)arrayList.get(i + 1)).getX();
            double d4 = ((Point2D)arrayList.get(i)).getY() - ((Point2D)arrayList.get(i + 1)).getY();
            if (d3 < d && d4 < d2) {
                for (n = i; n >= 0; --n) {
                    point2D = (Point2D)arrayList.get(n);
                    point2D.setLocation(point2D.getX() + d - d3, point2D.getY());
                }
            }
            d3 = ((Point2D)arrayList2.get(i)).getX() - ((Point2D)arrayList2.get(i + 1)).getX();
            d4 = ((Point2D)arrayList2.get(i)).getY() - ((Point2D)arrayList2.get(i + 1)).getY();
            if (!(d3 < d) || !(d4 < d2)) continue;
            for (n = i; n >= 0; --n) {
                point2D = (Point2D)arrayList2.get(n);
                point2D.setLocation(point2D.getX(), point2D.getY() + d2 - d4);
            }
        }
    }

    private void findCorrectPointOrder() {
        Point2D point2D = new Point2D.Double(0.0, 0.0);
        double d = 0.0;
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(this.points);
        while (arrayList2.size() > 0) {
            Point2D point2D2 = (Point2D)arrayList2.get(0);
            double d2 = 7.283185307179586;
            for (int i = 0; i < arrayList2.size(); ++i) {
                Point2D point2D3 = (Point2D)arrayList2.get(i);
                double d3 = point2D3.getY() != point2D.getY() ? Math.atan((point2D3.getX() - point2D.getX()) / (point2D3.getY() - point2D.getY())) : (point2D3.getX() > point2D.getX() ? 1.5707963267948966 : -1.5707963267948966);
                if (!((d3 = (d3 + Math.PI * 4 - d) % Math.PI) < d2)) continue;
                d2 = d3;
                point2D2 = point2D3;
            }
            point2D = point2D2;
            d = (d + d2) % (Math.PI * 2);
            arrayList2.remove(point2D2);
            arrayList.add(point2D2);
        }
        this.points = arrayList;
    }
}

