/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.CircleChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Set;

public class CircleLayoutAlgorithm
extends LayoutAlgorithm {
    private ArrayList boxes;

    public CircleLayoutAlgorithm() {
    }

    public CircleLayoutAlgorithm(Dimension dimension, Dimension dimension2, double d) {
        super(dimension, dimension2, d);
    }

    @Override
    public void layout(Graph graph, Set set) {
        int n;
        ArrayList arrayList = CircleLayoutAlgorithm.getMovableVertices(graph, set);
        if (graph == null || arrayList.size() == 0) {
            return;
        }
        this.boxes = new ArrayList();
        for (n = 0; n < arrayList.size(); ++n) {
            if (this.addToExistingBox(arrayList.get(n))) continue;
            Box box = new Box(graph, this.vertexDim, this.vertexBuffer);
            box.addVertex(arrayList.get(n));
            this.boxes.add(box);
        }
        for (n = this.boxes.size() - 1; n > 0; --n) {
            this.mergeIfPossible((Box)this.boxes.get(n), n);
        }
        for (n = 0; n < this.boxes.size(); ++n) {
            ((Box)this.boxes.get(n)).layoutInCircleAndPack();
        }
        CircleLayoutAlgorithm.shiftOntoScreen(graph, this.size, this.vertexDim, true);
    }

    private boolean addToExistingBox(Object object) {
        for (int i = 0; i < this.boxes.size(); ++i) {
            if (!((Box)this.boxes.get(i)).isEdgeToChainMember(object)) continue;
            ((Box)this.boxes.get(i)).addVertex(object);
            return true;
        }
        return false;
    }

    private void mergeIfPossible(Box box, int n) {
        for (int i = n - 1; i >= 0; --i) {
            Box box2 = (Box)this.boxes.get(i);
            for (int j = 0; j < box.size(); ++j) {
                if (!box2.isEdgeToChainMember(box.get(j))) continue;
                box2.merge(box);
                this.boxes.remove(box);
                return;
            }
        }
    }

    private class Box
    extends CircleChain {
        public Dimension size;
        public Box down;
        public Box right;
        public Point2D upperLeft;

        public Box(Graph graph, Dimension dimension, double d) {
            super(graph, dimension, d);
            this.upperLeft = new Point2D.Double(0.0, 0.0);
            this.right = null;
            this.down = null;
        }

        public void merge(Box box) {
            for (int i = 0; i < box.size(); ++i) {
                this.addVertex(box.get(i));
            }
        }

        public void setUpperLeft(Box box) {
            if (this.size.getHeight() <= box.size.getHeight()) {
                this.upperLeft = new Point2D.Double(this.upperLeft.getX() + box.size.getWidth(), this.upperLeft.getY());
                while (box.right != null) {
                    box = box.right;
                    this.upperLeft = new Point2D.Double(this.upperLeft.getX() + box.size.getWidth(), this.upperLeft.getY());
                }
                box.right = this;
                return;
            }
            this.upperLeft = new Point2D.Double(this.upperLeft.getX(), this.upperLeft.getY() + box.size.getHeight());
            if (box.down == null) {
                box.down = this;
            } else {
                this.setUpperLeft(box.down);
            }
        }

        public void layoutInCircleAndPack() {
            this.layoutInCircle();
            LayoutAlgorithm.polarToCartesian(this.graph, this.getVertices());
            this.size = new Dimension((int)(2.0 * (this.getRadius() + this.vertexBuffer) + (double)this.vertexDim.width), (int)(2.0 * (this.getRadius() + this.vertexBuffer) + (double)this.vertexDim.height));
            if (CircleLayoutAlgorithm.this.boxes.indexOf(this) != 0) {
                this.setUpperLeft((Box)CircleLayoutAlgorithm.this.boxes.get(0));
                for (int i = 0; i < this.size(); ++i) {
                    this.graph.moveVertex(this.get(i), new Point2D.Double(this.upperLeft.getX() + this.graph.pointForVertex(this.get(i)).getX(), this.upperLeft.getY() + this.graph.pointForVertex(this.get(i)).getY()));
                }
            }
        }
    }
}

