/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.Configuration;
import automata.State;

public class FSAConfiguration
extends Configuration {
    private String myInput;
    private String myUnprocessedInput;

    public FSAConfiguration(State state, FSAConfiguration fSAConfiguration, String string, String string2) {
        super(state, fSAConfiguration);
        this.myInput = string;
        this.myUnprocessedInput = string2;
    }

    public String getInput() {
        return this.myInput;
    }

    public String getUnprocessedInput() {
        return this.myUnprocessedInput;
    }

    public void setUnprocessedInput(String string) {
        this.myUnprocessedInput = string;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getUnprocessedInput();
    }

    @Override
    public boolean isAccept() {
        if (this.getUnprocessedInput().length() != 0) {
            return false;
        }
        State state = this.getCurrentState();
        Automaton automaton = state.getAutomaton();
        return automaton.isFinalState(state);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            return super.equals(object) && this.myUnprocessedInput.equals(((FSAConfiguration)object).myUnprocessedInput);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.myUnprocessedInput.hashCode();
    }
}

