/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.State;
import automata.Transition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class UselessStatesDetector {
    private UselessStatesDetector() {
    }

    public static Automaton cleanAutomaton(Automaton automaton) {
        Automaton automaton2 = (Automaton)automaton.clone();
        State[] stateArray = automaton2.getStates();
        Set set = UselessStatesDetector.getUselessStates(automaton2);
        for (int i = 0; i < stateArray.length; ++i) {
            if (!set.contains(stateArray[i]) || stateArray[i] == automaton2.getInitialState()) continue;
            automaton2.removeState(stateArray[i]);
        }
        if (set.contains(automaton2.getInitialState())) {
            Transition[] transitionArray = automaton2.getTransitions();
            for (int i = 0; i < transitionArray.length; ++i) {
                automaton2.removeTransition(transitionArray[i]);
            }
        }
        return automaton2;
    }

    public static Set getUselessStates(Automaton automaton) {
        if (automaton.getInitialState() == null) {
            throw new IllegalArgumentException("Automata does not have an initial state!");
        }
        Set set = UselessStatesDetector.findFinal(automaton);
        Set set2 = UselessStatesDetector.findInitial(automaton);
        HashSet<State> hashSet = new HashSet<State>(Arrays.asList(automaton.getStates()));
        set.retainAll(set2);
        hashSet.removeAll(set);
        return hashSet;
    }

    private static Set findFinal(Automaton automaton) {
        HashSet<State> hashSet = new HashSet<State>();
        hashSet.addAll(Arrays.asList(automaton.getFinalStates()));
        boolean bl = hashSet.size() != 0;
        Transition[] transitionArray = automaton.getTransitions();
        while (bl) {
            bl = false;
            for (int i = 0; i < transitionArray.length; ++i) {
                if (!hashSet.contains(transitionArray[i].getToState())) continue;
                bl = bl || hashSet.add(transitionArray[i].getFromState());
            }
        }
        return hashSet;
    }

    private static Set findInitial(Automaton automaton) {
        HashSet<State> hashSet = new HashSet<State>();
        hashSet.add(automaton.getInitialState());
        boolean bl = true;
        Transition[] transitionArray = automaton.getTransitions();
        while (bl) {
            bl = false;
            for (int i = 0; i < transitionArray.length; ++i) {
                if (!hashSet.contains(transitionArray[i].getFromState())) continue;
                bl = bl || hashSet.add(transitionArray[i].getToState());
            }
        }
        return hashSet;
    }
}

