/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.Node;
import automata.State;
import automata.Transition;
import java.util.ArrayList;

public class UnreachableStatesDetector {
    protected Automaton myAutomaton;
    protected Node[] myNodes;

    public UnreachableStatesDetector(Automaton automaton) {
        this.myAutomaton = automaton;
    }

    public void initializeNodes(State[] stateArray) {
        this.myNodes = new Node[stateArray.length];
        for (int i = 0; i < stateArray.length; ++i) {
            Node node = new Node(stateArray[i]);
            node.colorWhite();
            this.myNodes[i] = node;
        }
    }

    public State[] getUnreachableStates() {
        ArrayList<State> arrayList = new ArrayList<State>();
        State[] stateArray = this.myAutomaton.getStates();
        this.initializeNodes(stateArray);
        Node node = this.getNodeForState(this.myAutomaton.getInitialState());
        this.visit(node);
        for (int i = 0; i < this.myNodes.length; ++i) {
            if (!this.myNodes[i].isWhite()) continue;
            arrayList.add(this.myNodes[i].getState());
        }
        return arrayList.toArray(new State[0]);
    }

    public Node getNodeForState(State state) {
        for (int i = 0; i < this.myNodes.length; ++i) {
            Node node = this.myNodes[i];
            if (node.getState() != state) continue;
            return node;
        }
        return null;
    }

    public void visit(Node node) {
        node.colorGrey();
        Transition[] transitionArray = this.myAutomaton.getTransitionsFromState(node.getState());
        for (int i = 0; i < transitionArray.length; ++i) {
            Transition transition = transitionArray[i];
            State state = transition.getToState();
            Node node2 = this.getNodeForState(state);
            if (!node2.isWhite()) continue;
            this.visit(node2);
        }
        node.colorBlack();
    }
}

