/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class NaNb
extends RegularPumpingLemma {
    @Override
    public String getHTMLTitle() {
        return "<i>w</i> " + ELEMENT_OF + " " + AB_STAR + " : <i>n<sub>a</sub></i> (<i>w</i>) " + LESS_THAN + " <i>n<sub>b</sub></i> (<i>w</i>)";
    }

    @Override
    public String getTitle() {
        return "w element_of {ab}* : na(w) < nb(w)";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i>+1</sup>\".  The <i>y</i> value thus would be a multiple of \"a\".  For any <i>i</i> " + GREATER_THAN + " 1, n<sub>a</sub> " + GREATER_OR_EQ + " n<sub>b</sub>, " + "giving a string which is not in the language.  Thus, the language is not regular.";
    }

    @Override
    protected void chooseW() {
        this.w = NaNb.pumpString("a", this.getM()) + NaNb.pumpString("b", this.getM() + 1);
    }

    @Override
    public void chooseDecomposition() {
        this.setDecomposition(new int[]{Math.min(this.m - 1, this.w.indexOf(98)), 1});
    }

    @Override
    public void chooseI() {
        this.i = 2;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 17};
    }

    @Override
    public boolean isInLang(String string) {
        int n;
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(string, cArray)) {
            return false;
        }
        int n2 = LemmaMath.countInstances(string, 'a');
        return n2 < (n = LemmaMath.countInstances(string, 'b'));
    }
}

