/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class WW
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "ww : w element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>ww</i> : <i>w</i> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>a<sup><i>m</i></sup>b<sup><i>m</i></sup>\".  To be in the language with this example, <i>v</i> & <i>y</i> together cannot possess identical letters that are from separate blocks of alike letters (ex: <i>v</i> has \"b\"s from the first set of \"b\"s, while <i>y</i> has \"b\"s from the second set of \"b\"s.  Because of this, any increase or decrease in \"a\"s or \"b\"s will not be matched by any corresponding change in the other blocks of similar letters, resulting in an inequality that prevents the decomposition from working.  Thus, this language is not context-free.";
    }

    @Override
    protected void chooseW() {
        this.w = WW.pumpString("a", this.getM()) + WW.pumpString("b", this.getM()) + WW.pumpString("a", this.getM()) + WW.pumpString("b", this.getM());
    }

    @Override
    public void chooseDecomposition() {
        int n = this.w.length() / 2;
        if (this.m > n) {
            this.setDecomposition(new int[]{0, 1, n - 1, 1});
            return;
        }
        for (int i = n - this.m + 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.w.charAt(i) != this.w.charAt(j)) continue;
                String string = this.w.substring(0, i) + WW.pumpString("" + this.w.charAt(i), 2) + this.w.substring(i + 1, n);
                String string2 = this.w.substring(0, j) + WW.pumpString("" + this.w.charAt(j), 2) + this.w.substring(j + 1, n);
                int n2 = n - i + j - 1;
                if (!string.equals(string2) || n2 > this.m - 2) continue;
                this.setDecomposition(new int[]{i, 1, n2, 1});
                return;
            }
        }
        super.chooseDecomposition();
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 6};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{0, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") > -1 && string2.indexOf("a") < string2.indexOf("b");
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{1, 1, 0, WW.this.m - 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{WW.this.m - 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") > -1 && string.indexOf("a") < string.indexOf("b") && string2.indexOf("a") == -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{WW.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{WW.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string2.indexOf("a") > -1 && string2.indexOf("b") > -1 && string2.indexOf("a") > string2.indexOf("b");
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * WW.this.m - 2, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string2.indexOf("a") > -1 && string2.indexOf("b") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * WW.this.m - 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") > -1 && string.indexOf("a") > string.indexOf("b") && string2.indexOf("a") > -1 && string2.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * WW.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() == 0 && string2.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * WW.this.m, 0, 1, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() > 0 && string2.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * WW.this.m, 1, 0, 0};
            }
        });
    }

    @Override
    public boolean isInLang(String string) {
        String string2;
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(string, cArray)) {
            return false;
        }
        int n = string.length() / 2;
        String string3 = string.substring(0, n);
        return string3.equals(string2 = string.substring(n));
    }
}

