/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class W1CW2CW3CW4
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "w1cw2cw3cw4 : w1 = w2 or w3 = w4, wi element_of {ab}*, |wi| >= 5";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>w<sub>1</sub>cw<sub>2</sub>cw<sub>3</sub>cw<sub>4</sub></i>, : <i>w<sub>1</sub></i> = <i>w<sub>2</sub></i> or <i>w<sub>3</sub></i> = <i>w<sub>4</sub></i>, <i>w<sub>i</sub></i> " + ELEMENT_OF + " " + AB_STAR + ", |<i>w<sub>i</sub></i>| > 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>ca<sup><i>m</i></sup>b<sup><i>m</i></sup>cacb\".  If either <i>v</i> or <i>y</i> together span two 'w<sub>n</sub>'s or span less but possess a \"c\", then pumping that value could result in more or less than three \"c\"s, which is not permissible.  If either <i>v</i> or <i>y</i> span 'w<sub>3</sub>' or 'w<sub>4</sub>', then if <i>i</i> = 0, |'w<sub>3</sub>'| = 0 or |'w<sub>4</sub>'| = 0.  If either <i>v</i> or <i>y</i> span 'w<sub>1</sub>' or 'w<sub>2</sub>', then for any <i>i</i> " + NOT_EQUAL + " 1, 'w<sub>1</sub>' " + NOT_EQUAL + " 'w<sub>2</sub>'.  Thus, this language is not context-free.";
    }

    @Override
    protected void addCases() {
    }

    @Override
    protected void chooseW() {
        this.w = W1CW2CW3CW4.pumpString("a", this.m) + W1CW2CW3CW4.pumpString("b", this.m) + 'c' + W1CW2CW3CW4.pumpString("a", this.m) + W1CW2CW3CW4.pumpString("b", this.m) + "cacb";
    }

    @Override
    public void chooseDecomposition() {
        String[] stringArray = this.getWs(this.w);
        int[] nArray = this.checkIfPossibility(stringArray[0], stringArray[1], 0);
        if (nArray != null) {
            this.setDecomposition(nArray);
            return;
        }
        nArray = this.checkIfPossibility(stringArray[2], stringArray[3], stringArray[0].length() + stringArray[1].length() + 2);
        if (nArray != null) {
            this.setDecomposition(nArray);
            return;
        }
        super.chooseDecomposition();
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    private String[] getWs(String string) {
        String[] stringArray = new String[4];
        String string2 = string;
        for (int i = 0; i < 3; ++i) {
            int n = string2.indexOf(99);
            if (n == -1) {
                return null;
            }
            stringArray[i] = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        stringArray[3] = string2;
        return stringArray;
    }

    private int[] checkIfPossibility(String string, String string2, int n) {
        if (string.length() == 1 && string2.length() == 1) {
            return null;
        }
        if (string.length() == 1) {
            return new int[]{n + string.length() + 1, 1, 0, 0};
        }
        if (string2.length() == 1 || !string.equals(string2)) {
            return new int[]{n, 1, 0, 0};
        }
        if (this.m >= string2.length() + 2) {
            return new int[]{n, 1, string.length(), 1};
        }
        for (int i = string2.length() - this.m + 2; i < string2.length(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (string2.charAt(i) != string2.charAt(j)) continue;
                String string3 = string2.substring(0, i) + W1CW2CW3CW4.pumpString("" + string2.charAt(i), 2) + string2.substring(i + 1, string2.length());
                String string4 = string2.substring(0, j) + W1CW2CW3CW4.pumpString("" + string2.charAt(j), 2) + string2.substring(j + 1, string2.length());
                int n2 = string2.length() - i + j;
                if (!string3.equals(string4) || n2 > this.m - 2) continue;
                return new int[]{n + i, 1, n2, 1};
            }
        }
        return null;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 7};
    }

    @Override
    public boolean isInLang(String string) {
        String[] stringArray = this.getWs(string);
        if (stringArray == null) {
            return false;
        }
        char[] cArray = new char[]{'a', 'b'};
        for (int i = 0; i < 4; ++i) {
            if (!LemmaMath.otherCharactersFound(stringArray[i], cArray) && stringArray[i].length() != 0) continue;
            return false;
        }
        return stringArray[0].equals(stringArray[1]) || stringArray[2].equals(stringArray[3]);
    }
}

