/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class W1BnW2
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "w1 + b^n + w2 : na(w1) < na(w2) & na(w1) < n, w1 & w2 element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>w<sub>1</sub>b<sup>n</sup>w<sub>2</sub></i> : <i>n<sub>a</sub></i>(<i>w<sub>1</sub></i>) " + LESS_THAN + " <i>n<sub>a</sub></i>(<i>w<sub>2</sub></i>" + "),  n<sub>a</sub>(<i>w<sub>1</sub></i>) " + LESS_THAN + " <i>n</i>, " + "<i>w<sub>1</sub></i> & <i>w<sub>2</sub></i> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i>+1</sup>a<sup><i>m</i>+1</sup>\".  To be in the language with this example, <i>v</i> & <i>y</i> together cannot possess substrings that are from 'w'<sub>1</sub>, from b<sup>n</sup>, and from 'w<sub>2</sub>'.  Thus, if <i>i</i> = 0, <i>i</i> = 2, or perhaps both, either <i>v</i> or <i>y</i> will violate one of the conditions, meaning there is no valid decomposition.  Thus, this language is not context-free.";
    }

    @Override
    protected void addCases() {
    }

    @Override
    protected void chooseW() {
        this.w = W1BnW2.pumpString("a", this.m) + W1BnW2.pumpString("b", this.m + 1) + W1BnW2.pumpString("a", this.m + 1);
    }

    @Override
    public void chooseDecomposition() {
        for (int i = this.w.length() - 1; i >= 0; --i) {
            String string = this.w.substring(0, i) + this.w.substring(i + 1);
            if (!this.isInLang(string)) continue;
            this.setDecomposition(new int[]{i, 1, 0, 0});
            return;
        }
        super.chooseDecomposition();
    }

    @Override
    public void chooseI() {
        this.i = this.getU().length() < this.m ? 2 : 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 10};
    }

    @Override
    public boolean isInLang(String string) {
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(string, cArray)) {
            return false;
        }
        String string2 = null;
        for (int i = 0; i < string.length(); ++i) {
            int n;
            if (string.charAt(i) != 'b') continue;
            string2 = new String();
            while (i < string.length() && string.charAt(i) == 'b') {
                string2 = string2 + 'b';
                ++i;
            }
            String string3 = string.substring(0, i - string2.length());
            String string4 = i != string.length() ? string.substring(i) : "";
            int n2 = LemmaMath.countInstances(string3, 'a');
            if (n2 >= (n = LemmaMath.countInstances(string4, 'a')) || string2.length() <= n2) continue;
            return true;
        }
        return false;
    }
}

