/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class NagNbeNc
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "w element_of {abc}* : na(w) > nb(w) = nc(w)";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>w</i> " + ELEMENT_OF + " {<i>a</i>, <i>b</i>, <i>c</i>}* :" + " <i>n<sub>a</sub></i> (<i>w</i>) " + GREATER_THAN + " <i>n<sub>b</sub></i> (<i>w</i>) = <i>n<sub>c</sub></i> (<i>w</i>)";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i>+1</sup>b<sup><i>m</i></sup>c<sup><i>m</i></sup>\".  With this example, it is impossible to have \"a\"s, \"b\"s, and \"c\"s in both <i>v</i> and <i>y</i> together.  Thus, if <i>i</i> = 0, <i>i</i> = 2, or perhaps both, one of the inequalities will be violated, meaning there is no valid decomposition.  Thus, this language is not context-free.";
    }

    @Override
    protected void chooseW() {
        this.w = NagNbeNc.pumpString("a", this.getM() + 1) + NagNbeNc.pumpString("b", this.getM()) + NagNbeNc.pumpString("c", this.getM());
    }

    @Override
    public void chooseDecomposition() {
        int n;
        int n2 = LemmaMath.countInstances(this.w, 'a');
        if (n2 > (n = LemmaMath.countInstances(this.w, 'b')) + 1) {
            this.setDecomposition(new int[]{0, 1, 0, 0});
        } else {
            super.chooseDecomposition();
        }
    }

    @Override
    public void chooseI() {
        this.i = this.getV().indexOf("a") == -1 && this.getY().indexOf("a") == -1 ? 2 : 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 7};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") == -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{0, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{NagNbeNc.this.m - 1, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{NagNbeNc.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{NagNbeNc.this.m, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{NagNbeNc.this.m + 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * NagNbeNc.this.m - 1, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * NagNbeNc.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * NagNbeNc.this.m, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") == -1 && string.indexOf("c") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * NagNbeNc.this.m + 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() == 0 && string2.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * NagNbeNc.this.m, 0, 1, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() > 0 && string2.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * NagNbeNc.this.m, 1, 0, 0};
            }
        });
    }

    @Override
    public boolean isInLang(String string) {
        char[] cArray = new char[]{'a', 'b', 'c'};
        if (LemmaMath.otherCharactersFound(string, cArray)) {
            return false;
        }
        int n = LemmaMath.countInstances(string, 'a');
        int n2 = LemmaMath.countInstances(string, 'b');
        int n3 = LemmaMath.countInstances(string, 'c');
        return n > n2 && n2 == n3;
    }
}

