/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class AnBnCn
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "a^n b^n c^n";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>n</sup>c<sup>n</sup></i> : <i>n</i> " + GREATER_OR_EQ + " 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>c<sup><i>m</i></sup>\".  With this example, it is impossible to have \"a\"s, \"b\"s, and \"c\"s in both <i>v</i> and <i>y</i> together.  Thus, if <i>i</i> " + NOT_EQUAL + " 1, an inequality will be generated, meaning this is not a " + "context-free language.";
    }

    @Override
    protected void chooseW() {
        this.w = AnBnCn.pumpString("a", this.m) + AnBnCn.pumpString("b", this.m) + AnBnCn.pumpString("c", this.m);
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 11};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") == -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{0, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{1, 1, 0, AnBnCn.this.m - 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBnCn.this.m - 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBnCn.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AnBnCn.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBnCn.this.m - 2, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBnCn.this.m - 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBnCn.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") == -1 && string.indexOf("c") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBnCn.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() == 0 && string2.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBnCn.this.m, 0, 1, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() > 0 && string2.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AnBnCn.this.m, 1, 0, 0};
            }
        });
    }

    @Override
    public boolean isInLang(String string) {
        char[] cArray = new char[]{'a', 'b', 'c'};
        if (LemmaMath.isMixture(string, cArray)) {
            return false;
        }
        int n = LemmaMath.countInstances(string, 'a');
        int n2 = LemmaMath.countInstances(string, 'b');
        int n3 = LemmaMath.countInstances(string, 'c');
        return n == n2 && n == n3;
    }
}

