/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.DefaultTreeDrawer;
import java.awt.Color;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class SelectTreeDrawer
extends DefaultTreeDrawer {
    protected WeakHashMap selectedNodes = new WeakHashMap();
    protected Color deselectedColor = NODE_COLOR;
    protected Color selectedColor = SELECTED_NODE_COLOR;
    public static final Color NODE_COLOR = Color.yellow;
    public static final Color SELECTED_NODE_COLOR = NODE_COLOR.darker();

    public SelectTreeDrawer(TreeModel treeModel) {
        this(treeModel, NODE_COLOR, SELECTED_NODE_COLOR);
    }

    public SelectTreeDrawer(TreeModel treeModel, Color color, Color color2) {
        super(treeModel);
        this.deselectedColor = color;
        this.selectedColor = color2;
    }

    public boolean isSelected(TreeNode treeNode) {
        return this.selectedNodes.containsKey(treeNode);
    }

    public void setSelected(TreeNode treeNode, boolean bl) {
        if (bl) {
            this.selectedNodes.put(treeNode, null);
        } else {
            this.selectedNodes.remove(treeNode);
        }
    }

    public TreeNode[] getSelected() {
        HashSet hashSet = new HashSet(this.selectedNodes.keySet());
        for (TreeNode treeNode : hashSet) {
            if (treeNode.getParent() != null || treeNode == this.getModel().getRoot()) continue;
            this.selectedNodes.remove(treeNode);
        }
        return this.selectedNodes.keySet().toArray(new TreeNode[0]);
    }

    public void clearSelected() {
        this.selectedNodes.clear();
    }

    @Override
    protected Color getNodeColor(TreeNode treeNode) {
        return this.isSelected(treeNode) ? this.selectedColor : this.deselectedColor;
    }
}

