/*
 * Decompiled with CFR 0.152.
 */
package gui.sim.multiple;

import automata.Automaton;
import automata.Configuration;
import automata.turing.TMConfiguration;
import automata.turing.Tape;
import automata.turing.TuringMachine;
import grammar.Grammar;
import gui.GrowableTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class InputTableModel
extends GrowableTableModel {
    protected static final TableModelListener LISTENER = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            InputTableModel inputTableModel = (InputTableModel)tableModelEvent.getSource();
            if (tableModelEvent.getColumn() != -1 && tableModelEvent.getColumn() >= inputTableModel.getInputCount()) {
                return;
            }
            Integer n = new Integer(inputTableModel.getInputCount());
            INPUTS_TO_MODELS.put(n, inputTableModel);
        }
    };
    public boolean isMultiple = false;
    protected static final Map INPUTS_TO_MODELS = new HashMap();
    private final Map rowToAssociatedConfiguration = new HashMap();

    public InputTableModel(Automaton automaton, int n) {
        super(2 * InputTableModel.inputsForMachine(automaton) + 1 + n);
    }

    public InputTableModel(Grammar grammar, int n) {
        super(3 + n);
    }

    public InputTableModel(InputTableModel inputTableModel) {
        super(inputTableModel);
    }

    protected InputTableModel(int n) {
        super(n);
    }

    @Override
    protected Object[] initializeRow(int n) {
        Object[] objectArray = super.initializeRow(n);
        Arrays.fill(objectArray, "");
        return objectArray;
    }

    @Override
    public String getColumnName(int n) {
        int n2 = this.getColumnCount();
        if (n == n2 - 1) {
            return "Result";
        }
        int n3 = 0;
        if (this.isMultiple) {
            n3 = 1;
            if (n == 0) {
                return "File";
            }
        }
        String string = "";
        if (n <= this.getInputCount() - 1 + n3 && n >= n3) {
            string = "Input";
        } else if (n > this.getInputCount() - 1 + n3) {
            string = "Output";
            n -= this.getInputCount();
        }
        if (this.getInputCount() == 1) {
            return string;
        }
        return string + " " + (n + 1 - n3);
    }

    public String[][] getInputs() {
        String[][] stringArray = new String[this.getRowCount() - 1][this.getInputCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 0;
            if (this.isMultiple) {
                n = 1;
            }
            for (int j = 0; j < stringArray[i].length; ++j) {
                stringArray[i][j] = (String)this.getValueAt(i, j + n);
            }
        }
        return stringArray;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.isMultiple) {
            return n2 < this.getInputCount() && n2 > 0;
        }
        return n2 < this.getInputCount();
    }

    public static int inputsForMachine(Automaton automaton) {
        return automaton instanceof TuringMachine ? ((TuringMachine)automaton).tapes() : 1;
    }

    public int getInputCount() {
        int n = this.getColumnCount();
        if (this.isMultiple) {
            --n;
        }
        return n / 2;
    }

    public static InputTableModel getModel(Automaton automaton, boolean bl) {
        InputTableModel inputTableModel = (InputTableModel)INPUTS_TO_MODELS.get(new Integer(InputTableModel.inputsForMachine(automaton)));
        if (inputTableModel != null && inputTableModel.isMultiple == bl) {
            inputTableModel = new InputTableModel(inputTableModel);
            for (int i = 0; i < inputTableModel.getRowCount() - 1; ++i) {
                inputTableModel.setResult(i, "", null, null, 0);
            }
        } else {
            int n = 0;
            if (bl) {
                n = 1;
            }
            inputTableModel = new InputTableModel(automaton, n);
        }
        inputTableModel.addTableModelListener(LISTENER);
        if (bl) {
            inputTableModel.isMultiple = true;
        }
        return inputTableModel;
    }

    public static InputTableModel getModel(Grammar grammar, boolean bl) {
        InputTableModel inputTableModel = (InputTableModel)INPUTS_TO_MODELS.get(new Integer(1));
        if (inputTableModel != null) {
            inputTableModel = new InputTableModel(inputTableModel);
            for (int i = 0; i < inputTableModel.getRowCount() - 1; ++i) {
                inputTableModel.setResult(i, "", null, null, 0);
            }
        } else {
            int n = 0;
            if (bl) {
                n = 1;
            }
            inputTableModel = new InputTableModel(grammar, n);
        }
        inputTableModel.addTableModelListener(LISTENER);
        if (bl) {
            inputTableModel.isMultiple = true;
        }
        return inputTableModel;
    }

    public void setResult(int n, String string, Configuration configuration, ArrayList arrayList, int n2) {
        int n3 = this.getInputCount();
        if (this.isMultiple) {
            ++n3;
        }
        int n4 = 1;
        if (configuration instanceof TMConfiguration && configuration != null) {
            TMConfiguration tMConfiguration = (TMConfiguration)configuration;
            Tape[] tapeArray = tMConfiguration.getTapes();
            n4 = tapeArray.length;
            if (configuration.isAccept()) {
                for (int i = 0; i < tapeArray.length; ++i) {
                    String string2 = tapeArray[i].getOutput();
                    if (arrayList != null) {
                        String string3 = (String)arrayList.get(n2 + i);
                        if (!string3.equals("~") && !string3.equals(string2)) {
                            string2 = string2 + "(" + string3 + ")";
                        }
                        if (((String)arrayList.get(n2 + n4)).toLowerCase().startsWith("r")) {
                            if (!string.endsWith(")")) {
                                string = string + "(Reject)";
                            }
                            if (!string2.endsWith(")")) {
                                string2 = string2 + "(" + string3 + ")";
                            }
                        }
                    }
                    this.setValueAt(string2, n, n3 + i);
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    String string4 = "";
                    if (arrayList != null) {
                        String string5 = (String)arrayList.get(n2 + i);
                        if (!((String)arrayList.get(n2 + n4)).toLowerCase().startsWith("r")) {
                            if (!string.endsWith(")")) {
                                string = string + "(Accept)";
                            }
                            string4 = string4 + "(" + string5 + ")";
                        }
                    }
                    this.setValueAt(string4, n, n3 + i);
                }
            }
        } else {
            int n5 = 0;
            while (n3 + n5 < this.columns) {
                this.setValueAt("", n, n3 + n5);
                ++n5;
            }
            n5 = 0;
            if (configuration == null) {
                if (string.equals("Reject")) {
                    n5 = 0;
                }
            } else {
                n5 = configuration.isAccept() ? 1 : 0;
            }
            if (arrayList != null && n2 + n4 < arrayList.size()) {
                if (((String)arrayList.get(n2 + n4)).toLowerCase().startsWith("r") && n5 != 0) {
                    if (!string.endsWith(")")) {
                        string = string + "(Reject)";
                    }
                } else if (!((String)arrayList.get(n2 + n4)).toLowerCase().startsWith("r") && n5 == 0 && !string.endsWith(")")) {
                    string = string + "(Accept)";
                }
            } else if (arrayList == null || configuration == null) {
                // empty if block
            }
        }
        this.setValueAt(string, n, this.getColumnCount() - 1);
        if (configuration == null) {
            this.rowToAssociatedConfiguration.remove(new Integer(n));
        } else {
            this.rowToAssociatedConfiguration.put(new Integer(n), configuration);
        }
    }

    @Override
    public void clear() {
        if (this.rowToAssociatedConfiguration != null) {
            this.rowToAssociatedConfiguration.clear();
        }
        super.clear();
    }

    public Configuration getAssociatedConfigurationForRow(int n) {
        return (Configuration)this.rowToAssociatedConfiguration.get(new Integer(n));
    }
}

