/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import gui.TooltipAction;
import gui.sim.ConfigurationController;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JToolBar;

public class ControlPanel
extends JToolBar {
    private boolean blockStep = false;
    private ConfigurationController controller;

    public ControlPanel(ConfigurationController configurationController) {
        this.controller = configurationController;
        this.initView();
    }

    public ConfigurationController getController() {
        return this.controller;
    }

    protected void initView() {
        this.add(new TooltipAction("Step", "Moves existing valid configurations to the next configurations."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.controller.step(ControlPanel.this.blockStep);
            }
        });
        this.add(new TooltipAction("Reset", "Resets the simulation to start conditions."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.controller.reset();
            }
        });
        if (this.controller.isTuringMachine()) {
            this.add(new AbstractAction("Focus"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ControlPanel.this.controller.focus();
                }
            });
            this.add(new AbstractAction("Defocus"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ControlPanel.this.controller.defocus();
                }
            });
        }
        this.add(new AbstractAction("Freeze"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.controller.freeze();
            }
        });
        this.add(new AbstractAction("Thaw"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.controller.thaw();
            }
        });
        this.add(new AbstractAction("Trace"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.controller.trace();
            }
        });
        this.add(new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.controller.remove();
            }
        });
    }

    public void setBlock(boolean bl) {
        this.blockStep = bl;
    }
}

