/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.fsa.FiniteStateAutomaton;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBar;
import gui.editor.ToolBox;
import gui.environment.AutomatonEnvironment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import gui.regular.CollapseTool;
import gui.regular.FSAToREController;
import gui.regular.RegularStateTool;
import gui.regular.RegularTransitionTool;
import gui.regular.StateCollapseTool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConvertPane
extends JPanel {
    AutomatonEnvironment environment;
    private FiniteStateAutomaton automaton;

    public ConvertPane(AutomatonEnvironment automatonEnvironment) {
        this.environment = automatonEnvironment;
        this.automaton = (FiniteStateAutomaton)automatonEnvironment.getAutomaton().clone();
        EnvironmentFrame environmentFrame = Universe.frameForEnvironment(automatonEnvironment);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jLabel2, "South");
        this.add((Component)jPanel, "North");
        SelectionDrawer selectionDrawer = new SelectionDrawer(this.automaton);
        final FSAToREController fSAToREController = new FSAToREController(this.automaton, selectionDrawer, jLabel, jLabel2, environmentFrame);
        EditorPane editorPane = new EditorPane(selectionDrawer, new ToolBox(){

            @Override
            public List tools(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
                LinkedList<Tool> linkedList = new LinkedList<Tool>();
                linkedList.add(new ArrowNontransitionTool(automatonPane, automatonDrawer));
                linkedList.add(new RegularStateTool(automatonPane, automatonDrawer, fSAToREController));
                linkedList.add(new RegularTransitionTool(automatonPane, automatonDrawer, fSAToREController));
                linkedList.add(new CollapseTool(automatonPane, automatonDrawer, fSAToREController));
                linkedList.add(new StateCollapseTool(automatonPane, automatonDrawer, fSAToREController));
                return linkedList;
            }
        });
        ToolBar toolBar = editorPane.getToolBar();
        toolBar.addSeparator();
        toolBar.add(new JButton(new AbstractAction("Do It"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                fSAToREController.moveNextStep();
            }
        }));
        toolBar.add(new JButton(new AbstractAction("Export"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                fSAToREController.export();
            }
        }));
        this.add((Component)editorPane, "Center");
    }
}

