/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;

public class Text {
    public static final Text SPACE = new Text("_");
    protected static final Font FONT = new Font("Courier", 1, 20);
    protected String myText;
    protected Point2D.Double myBottomLeft;

    public Text() {
        this("");
    }

    public Text(String string) {
        this.myText = string;
        this.myBottomLeft = new Point2D.Double(0.0, 0.0);
    }

    public Text(String string, Point2D point2D) {
        this.myText = string;
        this.myBottomLeft = new Point2D.Double(point2D.getX(), point2D.getY());
    }

    public Text(Text text) {
        this.myText = text.myText;
        this.myBottomLeft = new Point2D.Double(text.myBottomLeft.getX(), text.myBottomLeft.getY());
    }

    public void setPos(Point2D point2D) {
        this.myBottomLeft = new Point2D.Double(point2D.getX(), point2D.getY());
    }

    public Point2D.Double getPos() {
        return this.myBottomLeft;
    }

    public void move(Point2D point2D) {
        this.myBottomLeft.x += point2D.getX();
        this.myBottomLeft.y += point2D.getY();
    }

    public double getWidth(Graphics graphics) {
        if (this.myText.length() == 0) {
            return 0.0;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.myText, FONT, fontRenderContext);
        return textLayout.getBounds().getWidth();
    }

    public double getHeight(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout("b", FONT, fontRenderContext);
        return textLayout.getBounds().getHeight();
    }

    public void paint(Graphics graphics) {
        if (this.myText.length() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.myText, FONT, fontRenderContext);
        textLayout.draw(graphics2D, (float)this.myBottomLeft.getX(), (float)this.myBottomLeft.getY());
    }

    public static Text getLabel(Graphics graphics, Text text, String string) {
        Text text2 = new Text(string);
        double d = text.getPos().x + text.getWidth(graphics) / 2.0 - text2.getWidth(graphics) / 2.0;
        double d2 = text.getPos().y - 2.0 * text.getHeight(graphics);
        text2.setPos(new Point2D.Double(d, d2));
        return text2;
    }

    public String toString() {
        return this.myText;
    }
}

