/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.ComputerFirstPane;
import pumping.ContextFreePumpingLemma;

public class CompCFPumpingLemmaInputPane
extends ComputerFirstPane {
    public CompCFPumpingLemmaInputPane(ContextFreePumpingLemma contextFreePumpingLemma) {
        super(contextFreePumpingLemma, "<i>L</i> = {" + contextFreePumpingLemma.getHTMLTitle() + "} Context-Free Pumping Lemma");
    }

    @Override
    protected void setCanvas() {
        this.stages[5].setVisible(true);
        this.myCanvas.reset();
        this.myCanvas.addText("w =");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getU(), "u");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getV(), "v");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getX(), "x");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getY(), "y");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getZ(), "z");
        this.myCanvas.moveText(new int[]{0, 1, this.myLemma.getI(), 1, this.myLemma.getI(), 1});
        this.myStepAnimation.setEnabled(true);
        this.myStartAnimation.setEnabled(false);
        this.repaint();
    }

    @Override
    protected String createXYZ() {
        return "<i>uv</i><sup>" + this.myLemma.getI() + "</sup><i>xy</i><sup>" + this.myLemma.getI() + "</sup><i>z</i>";
    }

    @Override
    public void update() {
        ContextFreePumpingLemma contextFreePumpingLemma = (ContextFreePumpingLemma)this.myLemma;
        this.stageMessages[0].setText("File loaded.");
        this.updateTopPane(false);
        int[] nArray = contextFreePumpingLemma.getDecomposition();
        if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0) {
            return;
        }
        this.myWDisplay.setText(contextFreePumpingLemma.getW());
        int[] nArray2 = new int[]{contextFreePumpingLemma.getU().length(), contextFreePumpingLemma.getV().length(), contextFreePumpingLemma.getX().length(), contextFreePumpingLemma.getY().length()};
        this.setDecomposition(nArray2, contextFreePumpingLemma.getI());
        if (this.myCases != null) {
            this.myCases.setDecomposition(nArray2);
        }
        this.decompLabel.setText(this.myLemma.getDecompositionAsString());
        this.stages[3].setVisible(true);
        this.stages[4].setVisible(true);
        if (contextFreePumpingLemma.getI() == -1) {
            return;
        }
        this.stages[5].setVisible(true);
        this.displayIEnd();
        this.stageMessages[5].setText("Click \"Restart\" to restart the animation.");
        this.stageMessages[5].setVisible(true);
        this.myCanvas.setRestartEnabled(true);
        if (this.myCases != null) {
            this.myCases.setAddReplaceButtonsEnabled(true);
        }
    }
}

