/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.State;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.MinimizeTreeNode;
import automata.fsa.Minimizer;
import gui.minimize.ControlPanel;
import gui.minimize.MinimizePane;
import gui.tree.SelectTreeDrawer;
import gui.tree.Trees;
import gui.viewer.SelectionDrawer;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class MinimizeController {
    private MinimizePane view;
    private SelectionDrawer automatonDrawer;
    private SelectTreeDrawer treeDrawer;
    private Minimizer minimizer;
    private MinimizeTreeNode expanding = null;
    private static final String CANT_SPLIT = "This group cannot be split on any terminal!";

    public MinimizeController(MinimizePane minimizePane, SelectionDrawer selectionDrawer, SelectTreeDrawer selectTreeDrawer, Minimizer minimizer) {
        this.view = minimizePane;
        this.automatonDrawer = selectionDrawer;
        this.treeDrawer = selectTreeDrawer;
        this.minimizer = minimizer;
    }

    public void stateDown(State state, MouseEvent mouseEvent) {
        if (state == null) {
            return;
        }
        TreeNode[] treeNodeArray = this.treeDrawer.getSelected();
        if (treeNodeArray.length != 1) {
            return;
        }
        this.toggleState((MinimizeTreeNode)treeNodeArray[0], state);
    }

    public void nodeClicked(MinimizeTreeNode minimizeTreeNode, MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        if (minimizeTreeNode == null) {
            this.automatonDrawer.clearSelected();
            this.treeDrawer.clearSelected();
            this.view.repaint();
            this.setEnabledness();
            return;
        }
        this.setSelectedStates(minimizeTreeNode);
        this.setEnabledness();
    }

    void setEnabledness() {
        String string;
        Object object;
        boolean bl;
        TreeNode[] treeNodeArray = this.treeDrawer.getSelected();
        ControlPanel controlPanel = this.view.controlPanel;
        State[] stateArray = this.minimizer.getDistinguishableGroup(this.getAutomaton(), this.getTree());
        boolean bl2 = bl = this.expanding == null && stateArray == null;
        if (bl) {
            controlPanel.finishAction.setEnabled(true);
            treeNodeArray = new TreeNode[]{};
            controlPanel.finishAction.setTip("Proceed to automaton building phase.");
        } else {
            controlPanel.finishAction.setEnabled(false);
            controlPanel.finishAction.setTip("Can't proceed.  Distinguishable groups still exist.");
        }
        if (treeNodeArray.length != 1) {
            object = bl ? "Tree is complete.  No action needed." : "This requires one node be selected.";
            controlPanel.setTerminalAction.setEnabled(false);
            controlPanel.setTerminalAction.setTip((String)object);
            controlPanel.autoPartitionAction.setEnabled(false);
            controlPanel.autoPartitionAction.setTip((String)object);
            controlPanel.completeSubtreeAction.setEnabled(false);
            controlPanel.autoPartitionAction.setTip((String)object);
            controlPanel.removeAction.setEnabled(false);
            controlPanel.autoPartitionAction.setTip((String)object);
        }
        if (this.expanding == null) {
            controlPanel.checkNodeAction.setEnabled(false);
            controlPanel.checkNodeAction.setTip("No group is being expanded.");
            controlPanel.addChildAction.setEnabled(false);
            controlPanel.addChildAction.setTip("No group is being expanded.");
        } else {
            object = this.minimizer.getString(this.expanding.getStates());
            controlPanel.checkNodeAction.setEnabled(true);
            controlPanel.checkNodeAction.setTip("Press to check expansion of group " + (String)object + ".");
            controlPanel.addChildAction.setEnabled(true);
            controlPanel.addChildAction.setTip("Add another partition to " + (String)object + ".");
        }
        if (treeNodeArray.length != 1) {
            return;
        }
        object = (MinimizeTreeNode)treeNodeArray[0];
        if (this.expanding != null && ((DefaultMutableTreeNode)object).getParent() == this.expanding) {
            string = this.minimizer.getString(this.expanding.getStates());
            controlPanel.removeAction.setEnabled(true);
            controlPanel.removeAction.setTip("Remove this partition from " + string + ".");
        } else {
            controlPanel.removeAction.setEnabled(false);
            controlPanel.removeAction.setTip("We're not expanding the parent.  Cannot delete.");
        }
        if (this.expanding == null) {
            string = this.minimizer.getString(((MinimizeTreeNode)object).getStates());
            controlPanel.completeSubtreeAction.setTip("Complete all distinguishable groups descending from group " + string + ".");
            controlPanel.completeSubtreeAction.setEnabled(true);
        } else {
            string = this.minimizer.getString(this.expanding.getStates());
            controlPanel.completeSubtreeAction.setEnabled(false);
            controlPanel.completeSubtreeAction.setTip("Must finish group " + string + " before we do this.");
        }
        if (this.expanding == object) {
            controlPanel.setTerminalAction.setEnabled(true);
            controlPanel.setTerminalAction.setTip("Set this group to expand on a different terminal.");
            controlPanel.autoPartitionAction.setEnabled(true);
            controlPanel.autoPartitionAction.setTip("Complete the expansion of this group on " + ((MinimizeTreeNode)object).getTerminal() + ".");
        } else if (this.expanding == null) {
            if (((DefaultMutableTreeNode)object).getChildCount() == 0) {
                controlPanel.setTerminalAction.setEnabled(true);
                controlPanel.setTerminalAction.setTip("Attempt to expand the group on a terminal.");
                controlPanel.autoPartitionAction.setEnabled(true);
                controlPanel.autoPartitionAction.setTip("Complete the expansion of this group on some terminal.");
            } else {
                string = "This group is already expanded.";
                controlPanel.setTerminalAction.setEnabled(false);
                controlPanel.setTerminalAction.setTip(string);
                controlPanel.autoPartitionAction.setEnabled(false);
                controlPanel.autoPartitionAction.setTip(string);
            }
        } else {
            string = this.minimizer.getString(this.expanding.getStates());
            controlPanel.setTerminalAction.setEnabled(false);
            controlPanel.setTerminalAction.setTip("Cannot expand another group while " + string + " is in progress.");
            controlPanel.autoPartitionAction.setEnabled(false);
            controlPanel.autoPartitionAction.setTip("Cannot expand another group while " + string + " is in progress.");
            return;
        }
    }

    public boolean splitOnTerminal(MinimizeTreeNode minimizeTreeNode) {
        if (!this.canExpand(minimizeTreeNode)) {
            return false;
        }
        if (minimizeTreeNode.getParent() == null) {
            JOptionPane.showMessageDialog(this.view, "You can't split the root!");
            return false;
        }
        MinimizeTreeNode[] minimizeTreeNodeArray = this.killChildren(minimizeTreeNode);
        if (!this.minimizer.isSplittable(minimizeTreeNode.getStates(), this.getAutomaton(), this.getTree())) {
            JOptionPane.showMessageDialog(this.view, CANT_SPLIT);
            this.addChildren(minimizeTreeNode, minimizeTreeNodeArray);
            return false;
        }
        String string = JOptionPane.showInputDialog(this.view, (Object)"What terminal?");
        if (string == null) {
            this.addChildren(minimizeTreeNode, minimizeTreeNodeArray);
            return false;
        }
        if (!this.minimizer.isSplittableOnTerminal(minimizeTreeNode.getStates(), string, this.getAutomaton(), this.getTree())) {
            JOptionPane.showMessageDialog(this.view, "The group doesn't split on that terminal!");
            this.addChildren(minimizeTreeNode, minimizeTreeNodeArray);
            return false;
        }
        minimizeTreeNode.setTerminal(string);
        this.expanding = minimizeTreeNode;
        this.addChild(minimizeTreeNode);
        this.addChild(minimizeTreeNode);
        this.view.repaint();
        return true;
    }

    public void nodeDown(MinimizeTreeNode minimizeTreeNode, MouseEvent mouseEvent) {
        if (minimizeTreeNode == null) {
            return;
        }
    }

    public void toggleState(MinimizeTreeNode minimizeTreeNode, State state) {
        Object object;
        State[] stateArray;
        if (!this.canModifyChild((MinimizeTreeNode)minimizeTreeNode.getParent())) {
            return;
        }
        try {
            stateArray = (State[])minimizeTreeNode.getParent();
            if (!Arrays.asList(stateArray.getStates()).contains(state)) {
                JOptionPane.showMessageDialog(this.view, "The group being split does not contain state " + state.getID() + "!");
                return;
            }
            object = Trees.children((TreeNode)stateArray);
            for (int i = 0; i < ((TreeNode[])object).length; ++i) {
                List<State> list;
                MinimizeTreeNode minimizeTreeNode2 = (MinimizeTreeNode)object[i];
                if (minimizeTreeNode2 == minimizeTreeNode || !(list = Arrays.asList(minimizeTreeNode2.getStates())).contains(state)) continue;
                JOptionPane.showMessageDialog(this.view, "Another partition already contains state " + state.getID() + "!");
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this.view, "One cannot change the states in the root!");
        }
        stateArray = minimizeTreeNode.getStates();
        object = new LinkedList<State>(Arrays.asList(stateArray));
        if (object.contains(state)) {
            object.remove(state);
        } else {
            object.add(state);
        }
        stateArray = object.toArray(new State[0]);
        minimizeTreeNode.setUserObject(stateArray);
        this.setSelectedStates(minimizeTreeNode);
        this.view.repaint();
    }

    private void split(MinimizeTreeNode minimizeTreeNode) {
        this.expanding = minimizeTreeNode;
        this.killChildren(minimizeTreeNode);
        ArrayList arrayList = this.minimizer.splitOnTerminal(minimizeTreeNode.getStates(), minimizeTreeNode.getTerminal(), this.getAutomaton(), this.getTree());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.addChild(minimizeTreeNode, (State[])iterator.next());
        }
        this.expanding = null;
    }

    public void splitWithInput(MinimizeTreeNode minimizeTreeNode) {
        if (!this.canExpand(minimizeTreeNode)) {
            return;
        }
        if (minimizeTreeNode.getTerminal().equals("")) {
            if (!this.minimizer.isSplittable(minimizeTreeNode.getStates(), this.getAutomaton(), this.getTree())) {
                JOptionPane.showMessageDialog(this.view, CANT_SPLIT);
                return;
            }
            if (!this.splitOnTerminal(minimizeTreeNode)) {
                return;
            }
        }
        this.split(minimizeTreeNode);
    }

    public void splitWithoutInput(MinimizeTreeNode minimizeTreeNode) {
        if (!this.canExpand(minimizeTreeNode)) {
            return;
        }
        if (minimizeTreeNode.getTerminal().equals("")) {
            if (!this.minimizer.isSplittable(minimizeTreeNode.getStates(), this.getAutomaton(), this.getTree())) {
                JOptionPane.showMessageDialog(this.view, CANT_SPLIT);
                return;
            }
            minimizeTreeNode.setTerminal(this.minimizer.getTerminalToSplit(minimizeTreeNode.getStates(), this.getAutomaton(), this.getTree()));
        }
        this.split(minimizeTreeNode);
    }

    public void splitSubtree(MinimizeTreeNode minimizeTreeNode) {
        TreeNode[] treeNodeArray;
        if (this.expanding != null) {
            JOptionPane.showMessageDialog(this.view, "We must finish expanding group " + this.minimizer.getString(this.expanding.getStates()) + "\nbefore we expand anything else.");
        }
        if ((treeNodeArray = Trees.children(minimizeTreeNode)).length == 0) {
            if (!this.minimizer.isSplittable(minimizeTreeNode.getStates(), this.getAutomaton(), this.getTree())) {
                minimizeTreeNode.setTerminal("");
                return;
            }
            minimizeTreeNode.setTerminal(this.minimizer.getTerminalToSplit(minimizeTreeNode.getStates(), this.getAutomaton(), this.getTree()));
            this.split(minimizeTreeNode);
            treeNodeArray = Trees.children(minimizeTreeNode);
        }
        for (int i = 0; i < treeNodeArray.length; ++i) {
            this.splitSubtree((MinimizeTreeNode)treeNodeArray[i]);
        }
    }

    private void setSelectedStates(MinimizeTreeNode minimizeTreeNode) {
        this.automatonDrawer.clearSelected();
        State[] stateArray = minimizeTreeNode.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            this.automatonDrawer.addSelected(stateArray[i]);
        }
        this.treeDrawer.clearSelected();
        this.treeDrawer.setSelected(minimizeTreeNode, true);
        this.view.repaint();
    }

    private MinimizeTreeNode[] killChildren(MinimizeTreeNode minimizeTreeNode) {
        TreeNode[] treeNodeArray = Trees.children(minimizeTreeNode);
        MinimizeTreeNode[] minimizeTreeNodeArray = new MinimizeTreeNode[treeNodeArray.length];
        for (int i = 0; i < treeNodeArray.length; ++i) {
            minimizeTreeNodeArray[i] = (MinimizeTreeNode)treeNodeArray[i];
            this.getTree().removeNodeFromParent(minimizeTreeNodeArray[i]);
        }
        return minimizeTreeNodeArray;
    }

    private DefaultTreeModel getTree() {
        return (DefaultTreeModel)this.treeDrawer.getModel();
    }

    private FiniteStateAutomaton getAutomaton() {
        return (FiniteStateAutomaton)this.automatonDrawer.getAutomaton();
    }

    public MinimizeTreeNode addChild() {
        return this.addChild(this.expanding);
    }

    public MinimizeTreeNode addChild(MinimizeTreeNode minimizeTreeNode) {
        if (minimizeTreeNode.getStates().length <= minimizeTreeNode.getChildCount()) {
            JOptionPane.showMessageDialog(this.view, "A group cannot have more partitions than elements!");
            return null;
        }
        return this.addChild(minimizeTreeNode, new State[0]);
    }

    public MinimizeTreeNode addChild(MinimizeTreeNode minimizeTreeNode, State[] stateArray) {
        if (!this.canModifyChild(minimizeTreeNode)) {
            return null;
        }
        MinimizeTreeNode minimizeTreeNode2 = new MinimizeTreeNode(stateArray);
        this.getTree().insertNodeInto(minimizeTreeNode2, minimizeTreeNode, minimizeTreeNode.getChildCount());
        this.view.repaint();
        return minimizeTreeNode2;
    }

    private void addChildren(MinimizeTreeNode minimizeTreeNode, MinimizeTreeNode[] minimizeTreeNodeArray) {
        for (int i = 0; i < minimizeTreeNodeArray.length; ++i) {
            this.getTree().insertNodeInto(minimizeTreeNodeArray[i], minimizeTreeNode, minimizeTreeNode.getChildCount());
        }
    }

    public void removeNode(MinimizeTreeNode minimizeTreeNode) {
        MinimizeTreeNode minimizeTreeNode2 = (MinimizeTreeNode)minimizeTreeNode.getParent();
        if (minimizeTreeNode2 == null) {
            JOptionPane.showMessageDialog(this.view, "One can't remove the root!");
            return;
        }
        if (!this.canModifyChild(minimizeTreeNode2)) {
            return;
        }
        this.getTree().removeNodeFromParent(minimizeTreeNode);
        this.view.repaint();
    }

    public boolean check() {
        if (this.expanding == null) {
            return false;
        }
        return this.check(this.expanding);
    }

    public boolean check(MinimizeTreeNode minimizeTreeNode) {
        Cloneable cloneable;
        MinimizeTreeNode[] minimizeTreeNodeArray = this.killChildren(minimizeTreeNode);
        if (!this.minimizer.isSplittable(minimizeTreeNode.getStates(), this.getAutomaton(), this.getTree())) {
            if (minimizeTreeNode.getTerminal().equals("") && minimizeTreeNodeArray.length == 0) {
                JOptionPane.showMessageDialog(this.view, "This group is correct!");
                this.addChildren(minimizeTreeNode, minimizeTreeNodeArray);
                return true;
            }
            this.addChildren(minimizeTreeNode, minimizeTreeNodeArray);
            JOptionPane.showMessageDialog(this.view, "This group is unsplittable, so it must\nhave no terminal, and no partitions.");
            return false;
        }
        HashSet<HashSet<State>> hashSet = new HashSet<HashSet<State>>();
        for (int i = 0; i < minimizeTreeNodeArray.length; ++i) {
            cloneable = minimizeTreeNodeArray[i];
            if (((MinimizeTreeNode)cloneable).getStates().length == 0) {
                this.addChildren(minimizeTreeNode, minimizeTreeNodeArray);
                JOptionPane.showMessageDialog(this.view, "One of the partitions is empty!");
                return false;
            }
            hashSet.add(new HashSet<State>(Arrays.asList(((MinimizeTreeNode)cloneable).getStates())));
        }
        HashSet<HashSet<State>> hashSet2 = new HashSet<HashSet<State>>();
        cloneable = this.minimizer.splitOnTerminal(minimizeTreeNode.getStates(), minimizeTreeNode.getTerminal(), this.getAutomaton(), this.getTree());
        this.addChildren(minimizeTreeNode, minimizeTreeNodeArray);
        Iterator iterator = ((ArrayList)cloneable).iterator();
        while (iterator.hasNext()) {
            hashSet2.add(new HashSet<State>(Arrays.asList((State[])iterator.next())));
        }
        if (!hashSet2.equals(hashSet)) {
            JOptionPane.showMessageDialog(this.view, "The parititons are wrong!");
            return false;
        }
        JOptionPane.showMessageDialog(this.view, "The expansion is correct!");
        this.expanding = null;
        return true;
    }

    private boolean canExpand(MinimizeTreeNode minimizeTreeNode) {
        if (this.expanding == null && minimizeTreeNode.getChildCount() > 0) {
            JOptionPane.showMessageDialog(this.view, "This group has already been expanded.");
            return false;
        }
        if (this.expanding == null || this.expanding == minimizeTreeNode) {
            return true;
        }
        JOptionPane.showMessageDialog(this.view, "We're already expanding the group " + this.minimizer.getString(this.expanding.getStates()) + "!");
        return false;
    }

    private boolean canModifyChild(MinimizeTreeNode minimizeTreeNode) {
        if (this.expanding == minimizeTreeNode && minimizeTreeNode != null) {
            return true;
        }
        if (minimizeTreeNode == null) {
            JOptionPane.showMessageDialog(this.view, "The root cannot be changed!");
            return false;
        }
        JOptionPane.showMessageDialog(this.view, "We cannot modify the partitions of a\ngroup we're not expanding!" + (this.expanding == null ? "" : "\nWe are expanding group " + this.minimizer.getString(this.expanding.getStates())));
        return false;
    }

    public boolean finished() {
        if (this.expanding != null) {
            JOptionPane.showMessageDialog(this.view, "We are expanding group " + this.minimizer.getString(this.expanding.getStates()) + "\nand so are not done.");
            return false;
        }
        State[] stateArray = this.minimizer.getDistinguishableGroup(this.getAutomaton(), this.getTree());
        if (stateArray == null) {
            this.view.beginMinimizedAutomaton(this.getAutomaton(), this.getTree());
            return true;
        }
        JOptionPane.showMessageDialog(this.view, "The tree is unfinished.  Group " + this.minimizer.getString(stateArray) + " may be partitioned.");
        return false;
    }
}

