/*
 * Decompiled with CFR 0.152.
 */
package gui.lsystem;

import gui.lsystem.Turtle;
import gui.transform.Matrix;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class Renderer {
    private Map handlers = new HashMap();
    private boolean areDrawing = false;
    private boolean isActive = false;
    private Stack turtleStack = new Stack();
    private Turtle currentTurtle;
    private Graphics2D g;
    private GeneralPath polygon = null;
    private GeneralPath linePath = new GeneralPath();
    private int drawnSofar;
    private int completedSymbols;
    private int totalSymbols;
    public static Set ASSIGN_WORDS;
    public static Set NONASSIGN_WORDS;

    public Renderer() {
        this.handlers.put("g", new MoveHandler(true, true));
        this.handlers.put("f", new MoveHandler(false, true));
        this.handlers.put("+", new TurnHandler(true));
        this.handlers.put("-", new TurnHandler(false));
        this.handlers.put("&", new PitchHandler(true));
        this.handlers.put("^", new PitchHandler(false));
        this.handlers.put("/", new RollHandler(true));
        this.handlers.put("*", new RollHandler(false));
        this.handlers.put("[", new PushTurtleHandler());
        this.handlers.put("]", new PopTurtleHandler());
        this.handlers.put("!", new WidthChangeHandler(true));
        this.handlers.put("~", new WidthChangeHandler(false));
        this.handlers.put("{", new BeginPolygonHandler());
        this.handlers.put("}", new ClosePolygonHandler());
        this.handlers.put("%", new ReverseHandler());
        this.handlers.put("#", new HueChangeHandler(false, true));
        this.handlers.put("@", new HueChangeHandler(false, false));
        this.handlers.put("##", new HueChangeHandler(true, true));
        this.handlers.put("@@", new HueChangeHandler(true, false));
        this.handlers.put("color", new DrawColorHandler());
        this.handlers.put("polygonColor", new PolygonColorHandler());
        AngleIncrementHandler angleIncrementHandler = new AngleIncrementHandler();
        this.handlers.put("angle", angleIncrementHandler);
        this.handlers.put("angleIncrement", angleIncrementHandler);
        this.handlers.put("lineWidth", new LineWidthHandler());
        this.handlers.put("lineIncrement", new LineWidthIncrementHandler());
        this.handlers.put("distance", new DistanceHandler());
        this.handlers.put("hueChange", new HueAngleIncrementHandler());
    }

    public CommandHandler getHandler(String string) {
        if (this.handlers.containsKey(string)) {
            return (CommandHandler)this.handlers.get(string);
        }
        return null;
    }

    public int getDoneSymbols() {
        return this.completedSymbols;
    }

    public void assign(String string, String string2) {
        try {
            try {
                if (!NONASSIGN_WORDS.contains(string)) {
                    this.currentTurtle.assign(string, string2);
                    string2 = this.currentTurtle.get(string).toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CommandHandler commandHandler = this.getHandler(string);
            commandHandler.handle(string2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Image render(List list, Map map, Matrix matrix, Graphics2D graphics2D, Point2D point2D) {
        BufferedImage bufferedImage = null;
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        if (graphics2D != null && graphics2D.getClip() == null) {
            throw new IllegalArgumentException("Graphics needs a non-null clip!");
        }
        if (matrix == null) {
            matrix = new Matrix();
        }
        this.totalSymbols = list.size() * 2;
        this.completedSymbols = 0;
        this.isActive = true;
        for (int i = 0; i < 2; ++i) {
            Iterator iterator;
            this.areDrawing = i == 1;
            this.drawnSofar = 0;
            this.turtleStack.clear();
            this.currentTurtle = new Turtle();
            this.currentTurtle.matrix = matrix;
            this.currentTurtle = new Turtle(this.currentTurtle);
            if (!this.areDrawing || graphics2D == null) {
                bufferedImage = new BufferedImage((int)((RectangularShape)rectangle2D).getWidth() + 10, (int)((RectangularShape)rectangle2D).getHeight() + 10, 2);
                this.g = bufferedImage.createGraphics();
                if (this.areDrawing) {
                    this.g.translate(-((RectangularShape)rectangle2D).getX() + 5.0, -((RectangularShape)rectangle2D).getY() + 5.0);
                    point2D.setLocation(5.0 - ((RectangularShape)rectangle2D).getX(), 5.0 - ((RectangularShape)rectangle2D).getY());
                    this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
            } else {
                double d;
                double d2;
                bufferedImage = null;
                this.g = (Graphics2D)graphics2D.create();
                iterator = new Rectangle2D.Double(((RectangularShape)rectangle2D).getX() - 5.0, ((RectangularShape)rectangle2D).getY() - 5.0, ((RectangularShape)rectangle2D).getWidth() + 10.0, ((RectangularShape)rectangle2D).getHeight() + 10.0);
                Rectangle rectangle = this.g.getClipBounds();
                double d3 = ((RectangularShape)((Object)iterator)).getWidth() / ((RectangularShape)((Object)iterator)).getHeight();
                if (d3 > (d2 = ((RectangularShape)rectangle).getWidth() / ((RectangularShape)rectangle).getHeight())) {
                    d = ((RectangularShape)((Object)iterator)).getWidth() / d2;
                    ((Rectangle2D)((Object)iterator)).setRect(((RectangularShape)((Object)iterator)).getX(), ((RectangularShape)((Object)iterator)).getY() - (d -= ((RectangularShape)((Object)iterator)).getHeight()) / 2.0, ((RectangularShape)((Object)iterator)).getWidth(), ((RectangularShape)((Object)iterator)).getHeight() + d);
                } else {
                    d = ((RectangularShape)((Object)iterator)).getHeight() * d2;
                    ((Rectangle2D)((Object)iterator)).setRect(((RectangularShape)((Object)iterator)).getX() - (d -= ((RectangularShape)((Object)iterator)).getWidth()) / 2.0, ((RectangularShape)((Object)iterator)).getY(), ((RectangularShape)((Object)iterator)).getWidth() + d, ((RectangularShape)((Object)iterator)).getHeight());
                }
                d = ((RectangularShape)rectangle).getWidth() / ((RectangularShape)((Object)iterator)).getWidth();
                this.g.scale(d, d);
                this.g.translate(((RectangularShape)rectangle).getX() - ((RectangularShape)((Object)iterator)).getX(), ((RectangularShape)rectangle).getY() - ((RectangularShape)((Object)iterator)).getY());
                point2D.setLocation(((RectangularShape)rectangle).getX() - ((RectangularShape)((Object)iterator)).getX(), ((RectangularShape)rectangle).getY() - ((RectangularShape)((Object)iterator)).getY());
            }
            for (Map.Entry entry : map.entrySet()) {
                try {
                    this.assign((String)entry.getKey(), (String)entry.getValue());
                }
                catch (Throwable throwable) {}
            }
            this.g.setColor(this.currentTurtle.getColor());
            this.capLinePath();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                ++this.completedSymbols;
                String string = (String)iterator.next();
                CommandHandler commandHandler = this.getHandler(string);
                if (commandHandler != null) {
                    try {
                        commandHandler.handle(null);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                int n = string.indexOf(61);
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    this.assign(string2, string3);
                }
                int n2 = string.indexOf(40);
                int n3 = string.lastIndexOf(41);
                if (n2 == -1 || n3 == -1 || n2 >= n3) continue;
                String string4 = string.substring(0, n2);
                String string5 = string.substring(n2 + 1, n3);
                commandHandler = this.getHandler(string4);
                try {
                    commandHandler.handle(string5);
                }
                catch (Throwable throwable) {}
            }
            this.capLinePath();
            this.g.dispose();
            while (!this.turtleStack.isEmpty()) {
                this.popTurtleStack();
            }
            rectangle2D = this.currentTurtle.getBounds();
        }
        this.isActive = false;
        this.areDrawing = false;
        return bufferedImage;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void popTurtleStack() {
        try {
            Turtle turtle = (Turtle)this.turtleStack.pop();
            turtle.updateBounds(this.currentTurtle);
            this.currentTurtle = turtle;
            this.g.setColor(this.currentTurtle.getColor());
            this.g.setStroke(this.currentTurtle.getStroke());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private final void capLinePath() {
        this.g.draw(this.linePath);
        this.linePath.reset();
        this.linePath.moveTo((float)this.currentTurtle.position.getX(), (float)this.currentTurtle.position.getY());
    }

    static {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("color");
        treeSet.add("polygonColor");
        NONASSIGN_WORDS = Collections.unmodifiableSet(new HashSet(treeSet));
        treeSet.add("angle");
        treeSet.add("lineWidth");
        treeSet.add("lineIncrement");
        treeSet.add("distance");
        treeSet.add("hueChange");
        ASSIGN_WORDS = Collections.unmodifiableSet(treeSet);
    }

    private class HueChangeHandler
    extends CommandHandler {
        private boolean add;
        private boolean polygon;

        public HueChangeHandler(boolean bl, boolean bl2) {
            this.polygon = bl;
            this.add = bl2;
        }

        @Override
        public final void handle(String string) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.capLinePath();
            if (string == null) {
                if (this.polygon) {
                    Renderer.this.currentTurtle.changePolygonHue(this.add);
                } else {
                    Renderer.this.currentTurtle.changeHue(this.add);
                }
            } else {
                double d = Renderer.this.currentTurtle.valueOf(string).doubleValue();
                double d2 = d = this.add ? d : -d;
                if (this.polygon) {
                    Renderer.this.currentTurtle.changePolygonHue(d);
                } else {
                    Renderer.this.currentTurtle.changeHue(d);
                }
            }
            Renderer.this.g.setColor(Renderer.this.currentTurtle.getColor());
        }
    }

    private class HueAngleIncrementHandler
    extends CommandHandler {
        private HueAngleIncrementHandler() {
        }

        @Override
        public final void handle(String string) {
            Renderer.this.currentTurtle.setHueChange(Double.parseDouble(string));
        }
    }

    private class ReverseHandler
    extends CommandHandler {
        private ReverseHandler() {
        }

        @Override
        public final void handle(String string) {
            Renderer.this.currentTurtle.turn(180.0);
        }
    }

    private class ClosePolygonHandler
    extends CommandHandler {
        private ClosePolygonHandler() {
        }

        @Override
        public final void handle(String string) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.capLinePath();
            Renderer.this.polygon.closePath();
            Renderer.this.g.setColor(((Renderer)Renderer.this).currentTurtle.polygonColor);
            Renderer.this.g.fill(Renderer.this.polygon);
            Renderer.this.polygon = null;
            Renderer.this.g.setColor(((Renderer)Renderer.this).currentTurtle.color);
            Renderer.this.drawnSofar++;
        }
    }

    private class BeginPolygonHandler
    extends CommandHandler {
        private BeginPolygonHandler() {
        }

        @Override
        public final void handle(String string) {
            if (!Renderer.this.areDrawing || Renderer.this.polygon != null) {
                return;
            }
            Renderer.this.capLinePath();
            Renderer.this.polygon = new GeneralPath();
            Renderer.this.polygon.moveTo((float)((Renderer)Renderer.this).currentTurtle.position.getX(), (float)((Renderer)Renderer.this).currentTurtle.position.getY());
        }
    }

    private class DistanceHandler
    extends CommandHandler {
        private DistanceHandler() {
        }

        @Override
        public final void handle(String string) {
            ((Renderer)Renderer.this).currentTurtle.distance = Double.parseDouble(string);
        }
    }

    private class LineWidthIncrementHandler
    extends CommandHandler {
        private LineWidthIncrementHandler() {
        }

        @Override
        public final void handle(String string) {
            Renderer.this.currentTurtle.setLineIncrement(Double.parseDouble(string));
        }
    }

    private class LineWidthHandler
    extends CommandHandler {
        private LineWidthHandler() {
        }

        @Override
        public final void handle(String string) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.capLinePath();
            Renderer.this.currentTurtle.setLineWidth(Double.parseDouble(string));
            Renderer.this.g.setStroke(Renderer.this.currentTurtle.getStroke());
        }
    }

    private class AngleIncrementHandler
    extends CommandHandler {
        private AngleIncrementHandler() {
        }

        @Override
        public final void handle(String string) {
            Renderer.this.currentTurtle.setAngleChange(Double.parseDouble(string));
        }
    }

    private class PolygonColorHandler
    extends CommandHandler {
        private PolygonColorHandler() {
        }

        @Override
        public final void handle(String string) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.currentTurtle.setPolygonColor(string);
        }
    }

    private class DrawColorHandler
    extends CommandHandler {
        private DrawColorHandler() {
        }

        @Override
        public final void handle(String string) {
            if (!Renderer.this.areDrawing) {
                return;
            }
            Renderer.this.capLinePath();
            Renderer.this.currentTurtle.setColor(string);
            Renderer.this.g.setColor(Renderer.this.currentTurtle.getColor());
        }
    }

    private class WidthChangeHandler
    extends CommandHandler {
        private boolean increment;

        public WidthChangeHandler(boolean bl) {
            this.increment = bl;
        }

        @Override
        public final void handle(String string) {
            Renderer.this.capLinePath();
            if (string == null) {
                Renderer.this.currentTurtle.changeLineWidth(this.increment);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(string).doubleValue();
                Renderer.this.currentTurtle.changeLineWidth(this.increment ? d : -d);
            }
            Renderer.this.g.setStroke(Renderer.this.currentTurtle.getStroke());
        }
    }

    private class PopTurtleHandler
    extends CommandHandler {
        private PopTurtleHandler() {
        }

        @Override
        public final void handle(String string) {
            Renderer.this.capLinePath();
            Renderer.this.popTurtleStack();
            Renderer.this.capLinePath();
        }
    }

    private class PushTurtleHandler
    extends CommandHandler {
        private PushTurtleHandler() {
        }

        @Override
        public final void handle(String string) {
            Renderer.this.turtleStack.push(Renderer.this.currentTurtle.clone());
        }
    }

    private class RollHandler
    extends CommandHandler {
        private boolean right;

        public RollHandler(boolean bl) {
            this.right = bl;
        }

        @Override
        public final void handle(String string) {
            if (string == null) {
                Renderer.this.currentTurtle.roll(this.right);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(string).doubleValue();
                Renderer.this.currentTurtle.roll(this.right ? -d : d);
            }
        }
    }

    private class PitchHandler
    extends CommandHandler {
        private boolean down;

        public PitchHandler(boolean bl) {
            this.down = bl;
        }

        @Override
        public final void handle(String string) {
            if (string == null) {
                Renderer.this.currentTurtle.pitch(this.down);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(string).doubleValue();
                Renderer.this.currentTurtle.pitch(this.down ? d : -d);
            }
        }
    }

    private class TurnHandler
    extends CommandHandler {
        private boolean clockwise;

        public TurnHandler(boolean bl) {
            this.clockwise = bl;
        }

        @Override
        public final void handle(String string) {
            if (string == null) {
                Renderer.this.currentTurtle.turn(this.clockwise);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(string).doubleValue();
                Renderer.this.currentTurtle.turn(this.clockwise ? -d : d);
            }
        }
    }

    private class MoveHandler
    extends CommandHandler {
        private boolean pendown;
        private boolean forward;
        private Line2D line;

        public MoveHandler(boolean bl, boolean bl2) {
            this.line = new Line2D.Double();
            this.pendown = bl;
            this.forward = bl2;
        }

        @Override
        public final void handle(String string) {
            if (string == null) {
                Renderer.this.currentTurtle.go(this.forward);
            } else {
                double d = Renderer.this.currentTurtle.valueOf(string).doubleValue();
                Renderer.this.currentTurtle.go(this.forward ? d : -d);
            }
            if (!Renderer.this.areDrawing) {
                return;
            }
            if (this.pendown) {
                if (Renderer.this.polygon == null) {
                    Renderer.this.linePath.lineTo((float)((Renderer)Renderer.this).currentTurtle.position.getX(), (float)((Renderer)Renderer.this).currentTurtle.position.getY());
                } else {
                    Renderer.this.polygon.lineTo((float)((Renderer)Renderer.this).currentTurtle.position.getX(), (float)((Renderer)Renderer.this).currentTurtle.position.getY());
                }
            } else {
                Renderer.this.linePath.moveTo((float)((Renderer)Renderer.this).currentTurtle.position.getX(), (float)((Renderer)Renderer.this).currentTurtle.position.getY());
            }
        }
    }

    protected class CommandHandler {
        protected CommandHandler() {
        }

        public void handle(String string) {
        }
    }
}

