/*
 * Decompiled with CFR 0.152.
 */
package gui.lsystem;

import grammar.Production;
import grammar.UnboundGrammar;
import grammar.lsystem.LSystem;
import gui.HighlightTable;
import gui.TableTextSizeSlider;
import gui.grammar.GrammarInputPane;
import gui.lsystem.LSystemInputEvent;
import gui.lsystem.LSystemInputListener;
import gui.lsystem.ParameterTableModel;
import gui.lsystem.Renderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class LSystemInputPane
extends JPanel {
    private static final LSystem SYSTEM = new LSystem();
    private JTextField axiomField;
    private GrammarInputPane productionInputPane;
    private ParameterTableModel parameterModel;
    private HighlightTable parameterTable;
    private Set lSystemInputListeners = new HashSet();
    private LSystemInputEvent reusedEvent = new LSystemInputEvent(this);
    private LSystem cachedSystem = null;

    public LSystemInputPane() {
        this(SYSTEM);
    }

    public LSystemInputPane(LSystem lSystem) {
        super(new BorderLayout());
        this.initializeStructures(lSystem);
        this.initializeListener();
        this.initializeView();
    }

    private void initializeStructures(LSystem lSystem) {
        this.axiomField = new JTextField(LSystemInputPane.listAsString(lSystem.getAxiom()));
        Set set = lSystem.getSymbolsWithReplacements();
        Iterator iterator = set.iterator();
        UnboundGrammar unboundGrammar = new UnboundGrammar();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List[] listArray = lSystem.getReplacements(string);
            for (int i = 0; i < listArray.length; ++i) {
                Production production = new Production(string, LSystemInputPane.listAsString(listArray[i]));
                unboundGrammar.addProduction(production);
            }
        }
        this.productionInputPane = new GrammarInputPane(unboundGrammar);
        this.parameterModel = new ParameterTableModel(lSystem.getValues());
        this.cachedSystem = lSystem;
    }

    private void initializeView() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Axiom: "), "West");
        jPanel.add((Component)this.axiomField, "Center");
        this.add((Component)jPanel, "North");
        this.parameterTable = new HighlightTable(this.parameterModel);
        this.parameterTable.add((Component)new TableTextSizeSlider(this.parameterTable), "South");
        JScrollPane jScrollPane = new JScrollPane(this.parameterTable);
        Dimension dimension = new Dimension(400, 200);
        this.productionInputPane.setPreferredSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        JSplitPane jSplitPane = new JSplitPane(0, this.productionInputPane, jScrollPane);
        this.add((Component)jSplitPane, "Center");
        this.parameterTable.setShowGrid(true);
        this.parameterTable.setGridColor(Color.lightGray);
        jScrollPane.setVerticalScrollBarPolicy(22);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LSystemInputPane.this.setEditing(actionEvent.getActionCommand());
            }
        };
        String[] stringArray = Renderer.ASSIGN_WORDS.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            jPopupMenu.add(stringArray[i]).addActionListener(actionListener);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        });
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jPanel2);
    }

    public void initializeListener() {
        this.axiomField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                LSystemInputPane.this.fireLSystemInputEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LSystemInputPane.this.fireLSystemInputEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                LSystemInputPane.this.fireLSystemInputEvent();
            }
        });
        TableModelListener tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                LSystemInputPane.this.fireLSystemInputEvent();
            }
        };
        this.parameterModel.addTableModelListener(tableModelListener);
        this.productionInputPane.getTable().getModel().addTableModelListener(tableModelListener);
    }

    public static String listAsString(List list) {
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuffer.append(' ');
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public LSystem getLSystem() {
        if (this.productionInputPane.getTable().getCellEditor() != null) {
            this.productionInputPane.getTable().getCellEditor().stopCellEditing();
        }
        if (this.parameterTable.getCellEditor() != null) {
            this.parameterTable.getCellEditor().stopCellEditing();
        }
        try {
            if (this.cachedSystem == null) {
                this.cachedSystem = new LSystem(this.axiomField.getText(), this.productionInputPane.getGrammar(UnboundGrammar.class), this.parameterModel.getParameters());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), "L-System Error", 0);
        }
        return this.cachedSystem;
    }

    public void addLSystemInputListener(LSystemInputListener lSystemInputListener) {
        this.lSystemInputListeners.add(lSystemInputListener);
    }

    public void removeLSystemInputListener(LSystemInputListener lSystemInputListener) {
        this.lSystemInputListeners.remove(lSystemInputListener);
    }

    protected void fireLSystemInputEvent() {
        this.cachedSystem = null;
        Iterator iterator = this.lSystemInputListeners.iterator();
        while (iterator.hasNext()) {
            ((LSystemInputListener)iterator.next()).lSystemChanged(this.reusedEvent);
        }
    }

    private void setEditing(String string) {
        int n;
        for (n = 0; n < this.parameterModel.getRowCount() && !this.parameterModel.getValueAt(n, 0).equals(string); ++n) {
        }
        if (n == this.parameterModel.getRowCount()) {
            this.parameterModel.setValueAt(string, --n, 0);
        }
        int n2 = this.parameterTable.convertColumnIndexToView(1);
        this.parameterTable.editCellAt(n, n2);
        this.parameterTable.requestFocus();
    }
}

